/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class ArrayImpl
extends CloneableDataObject
implements Array {
    Object[] array;

    public ArrayImpl(Object[] array) throws SQLException {
        if (array == null) {
            throw new SQLException("Argument array is null.");
        }
        this.array = array;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return SQLType.typeForClass(this.array[0].getClass()).getTypeName();
    }

    @Override
    public int getBaseType() throws SQLException {
        return SQLType.typeForClass(this.array[0].getClass()).getType();
    }

    @Override
    public Object getArray() throws SQLException {
        return this.array;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        if (index < 1L) {
            throw new SQLException("Argument index is out of range");
        }
        if ((long)count + index - 1L > (long)this.array.length) {
            throw new SQLException("Argument count is out of range");
        }
        Object[] newArray = new Object[count];
        for (int i = 0; i < count; ++i) {
            newArray[i] = this.array[i + (int)index - 1];
        }
        return newArray;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getArray(index, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, this.array.length);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        if (index < 1L) {
            throw new SQLException("Argument index is out of range");
        }
        if ((long)count + index - 1L > (long)this.array.length) {
            throw new SQLException("Argument count is out of range");
        }
        RowMetaData rowMetaData = new RowMetaData();
        rowMetaData.addColumn("C1", SQLType.INTEGER);
        rowMetaData.addColumn("C2", SQLType.typeForClass(this.array[0].getClass()));
        RowSet rowSet = new RowSet(rowMetaData);
        for (int i = 0; i < count; ++i) {
            rowSet.addToRowSet(new Object[]{(long)i + index, this.array[i + (int)index - 1]});
        }
        return rowSet;
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet(index, count);
    }

    @Override
    public void free() throws SQLException {
        this.array = null;
    }
}

