/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.operation;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.operation.SLMessageSequenceId;
import com.streamscape.slex.MFSession;

public class SLMessage
extends CloneableDataObject {
    public static final String EVENT_ID = "e.sys.sl.Message";
    private String text;
    private Type type = Type.INFO;
    private Throwable exception;
    private String componentName;
    private String slSessionName;
    private SLMessageSequenceId messageSequenceId;

    public SLMessage() {
    }

    public SLMessage(String text, String componentName, String slSessionName) {
        this(text, true);
        this.init(componentName, slSessionName);
    }

    public SLMessage(String text, boolean isOK, String componentName, String slSessionName) {
        this(text, isOK);
        this.init(componentName, slSessionName);
    }

    public SLMessage(String text, boolean isOK, MFSession session) {
        this(text, isOK ? Type.INFO : Type.ERROR, session);
    }

    public SLMessage(String text, Type type, MFSession session) {
        this(text, type);
        this.init(session);
    }

    public SLMessage(String text, MFSession session) {
        this(text, true, session);
    }

    private SLMessage(String text, boolean isOK) {
        this(text, isOK ? Type.INFO : Type.ERROR);
    }

    private SLMessage(String text, Type type) {
        this.text = text;
        this.type = type;
    }

    public SLMessage(Throwable exception, MFSession session) {
        this.exception = exception;
        this.type = Type.ERROR;
        this.init(session);
    }

    public SLMessage(SLMessage other, MFSession session) {
        this.text = other.text;
        this.type = other.type;
        this.exception = other.exception;
        this.messageSequenceId = other.messageSequenceId;
        this.init(session);
    }

    private void init(MFSession session) {
        this.init(session.getComponentName(), session.getSLSessionName());
    }

    private void init(String componentName, String slSessionName) {
        this.componentName = componentName;
        this.slSessionName = slSessionName;
    }

    public String getText() {
        return this.text;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getSLSessionName() {
        return this.slSessionName;
    }

    public void setSLSessionName(String slSessionName) {
        this.slSessionName = slSessionName;
    }

    public Type getType() {
        return this.type;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isOK() {
        return this.type == Type.INFO;
    }

    public void setMessageSequenceId(SLMessageSequenceId messageSequenceId) {
        this.messageSequenceId = messageSequenceId;
    }

    public SLMessageSequenceId getMessageSequenceId() {
        return this.messageSequenceId;
    }

    public String toString() {
        return "SLMessage(" + this.text + ", " + this.componentName + ", " + this.slSessionName + ")";
    }

    public static enum Type {
        INFO,
        WARNING,
        ERROR;

    }
}

