/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.operation;

import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.slex.lang.completion.DSLCompletion;
import java.util.List;

public class SLFileMessage
extends SLMessage {
    public static final String EVENT_ID = "e.sys.sl.FileMessage";
    public static final long OPERATION_NOT_SUPPORTED = -1234L;
    private FileOperation operation;
    private String filename;
    private long length;
    private long lengthTotal;
    private long lengthProcessed;
    private byte[] bytes;
    private List<String> files;
    private long timeout = -1L;
    private DSLCompletion completion = null;
    private boolean isError = false;
    private boolean verbose = true;
    private FileInfo[] fileInfos;
    private FilePermissions permissions;
    private boolean recursive;
    private String dstFilename;
    private String username;
    private String groupname;
    private boolean overwrite = false;
    private String sessionName;
    private String resourceName;

    public static String getRequestConsumerName() {
        return "sys$SlangFileRequestConsumer";
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public FileOperation getOperation() {
        return this.operation;
    }

    public void setOperation(FileOperation operation) {
        this.operation = operation;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getLengthTotal() {
        return this.lengthTotal;
    }

    public void setLengthTotal(long lengthTotal) {
        this.lengthTotal = lengthTotal;
    }

    public long getLengthProcessed() {
        return this.lengthProcessed;
    }

    public void setLengthProcessed(long lengthProcessed) {
        this.lengthProcessed = lengthProcessed;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public DSLCompletion getDSLCompletion() {
        return this.completion;
    }

    public void setDSLCompletion(DSLCompletion completion) {
        this.completion = completion;
    }

    public boolean isNotSupported() {
        return this.length == -1234L;
    }

    public void setNotSupported() {
        this.length = -1234L;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setError() {
        this.isError = true;
    }

    @Override
    public String getText() {
        return this.getText(null);
    }

    public String getText(String action) {
        switch (this.operation.ordinal()) {
            case 0: {
                return this.getAction(action, "download", true) + "ing file '" + this.getFilename() + "' (" + this.getLengthTotal() + " bytes)...\n";
            }
            case 1: {
                return this.getAction(action, "upload", true) + "ing file '" + this.getFilename() + "'" + (String)(this.getLengthTotal() > 0L ? " (" + this.getLengthTotal() + " bytes)" : "") + "...\n";
            }
            case 2: {
                return this.getAction(action, "upload", true) + "ing (appending) file '" + this.getFilename() + "'" + (String)(this.getLengthTotal() > 0L ? " (" + this.getLengthTotal() + " bytes)" : "") + "...\n";
            }
            case 3: {
                return "File '" + this.getFilename() + "' created.\n";
            }
            case 8: {
                return this.isError ? "" : "File '" + this.getFilename() + "' " + this.getAction(action, "download", false) + "ed.\n";
            }
            case 9: {
                return this.isError ? "" : "File '" + this.getFilename() + "' " + this.getAction(action, "upload", false) + "ed.\n";
            }
            case 14: {
                return "File '" + this.getFilename() + "' removed.\n";
            }
            case 13: {
                return "Directory '" + this.getFilename() + "' created.\n";
            }
            case 4: {
                return "..." + this.getAction(action, "download", true) + "ed " + this.getPercent() + "\n";
            }
            case 5: {
                return "..." + this.getAction(action, "upload", true) + "ed " + this.getPercent() + "\n";
            }
            case 6: {
                return "Skipped " + this.getLength() + " bytes of " + String.valueOf(this.getLengthTotal() > 0L ? Long.valueOf(this.getLengthTotal()) : "total") + " from file '" + this.getFilename() + "'.\n";
            }
        }
        return this.toString();
    }

    private String getAction(String action, String defaultAction, boolean capitalized) {
        if (action == null) {
            action = defaultAction;
        }
        return capitalized ? StringUtils.toCapitalized(action) : action;
    }

    private String getPercent() {
        return this.getLengthTotal() > 0L ? String.format("%.2f", (double)this.getCurrentLength() / (double)this.getLengthTotal() * 100.0) + "%" : this.getCurrentLength() + " of total bytes.";
    }

    private long getCurrentLength() {
        return this.getLengthProcessed() + this.getLength();
    }

    @Override
    public String toString() {
        return super.toString() + String.valueOf((Object)this.operation) + "(" + this.filename + ", length: " + this.length + ", bytes: " + String.valueOf(this.bytes != null ? Integer.valueOf(this.bytes.length) : "null") + ", processed " + this.lengthProcessed + " of " + this.lengthTotal + ")";
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public FileInfo[] getFileInfos() {
        return this.fileInfos;
    }

    public SLFileMessage setFileInfos(FileInfo[] fileInfos) {
        this.fileInfos = fileInfos;
        return this;
    }

    public FilePermissions getPermissions() {
        return this.permissions;
    }

    public SLFileMessage setPermissions(FilePermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public SLFileMessage setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public String getDstFilename() {
        return this.dstFilename;
    }

    public SLFileMessage setDstFilename(String dstFilename) {
        this.dstFilename = dstFilename;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public SLFileMessage setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public SLFileMessage setGroupname(String groupname) {
        this.groupname = groupname;
        return this;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public SLFileMessage setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public static enum FileOperation {
        OPEN_FOR_READ,
        OPEN_FOR_WRITE,
        OPEN_FOR_APPEND,
        CREATE,
        READ,
        WRITE,
        SKIP,
        AVAILABLE_FOR_READ,
        CLOSE_READING,
        CLOSE_WRITING,
        EXISTS,
        IS_DIRECTORY,
        LIST_DIRECTORY,
        CREATE_DIRECTORY,
        REMOVE,
        COMPLETE,
        FILE_SYSTEM_GET_FILE_INFO,
        FILE_SYSTEM_LIST,
        FILE_SYSTEM_COPY,
        FILE_SYSTEM_MOVE,
        FILE_SYSTEM_RENAME,
        FILE_SYSTEM_SET_OWNER,
        FILE_SYSTEM_SET_PERMISSIONS,
        FILE_SYSTEM_CREATE_NEW_FILE;

    }
}

