/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.operation;

import com.streamscape.sdo.operation.SLMessage;
import javax.sound.sampled.AudioFormat;

public class SLAudioMessage
extends SLMessage {
    public static final String EVENT_ID = "e.sys.sl.AudioMessage";
    public static final long OPERATION_NOT_SUPPORTED = -1234L;
    private String uniqueStreamId;
    private AudioOperation operation;
    private AudioFormat audioFormat;
    private byte[] bytes;
    private int length;
    private boolean isError = false;
    private boolean verbose = true;
    private long timeout = -1L;
    private String sessionName;
    private String resourceName;

    public static String getRequestConsumerName() {
        return "sys$SlangAudioRequestConsumer";
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public AudioOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AudioOperation operation) {
        this.operation = operation;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setError() {
        this.isError = true;
    }

    @Override
    public String getText() {
        switch (this.operation.ordinal()) {
            case 0: {
                return "Open audio stream in format " + String.valueOf(this.audioFormat) + "...\n";
            }
            case 1: {
                return "Close audio stream in format " + String.valueOf(this.audioFormat) + "...\n";
            }
            case 2: {
                return "Read " + String.valueOf(this.bytes != null ? Integer.valueOf(this.bytes.length) : "0") + " from audio stream...\n";
            }
        }
        return this.toString();
    }

    @Override
    public String toString() {
        return super.toString() + String.valueOf((Object)this.operation) + " (bytes: " + String.valueOf(this.bytes != null ? Integer.valueOf(this.bytes.length) : "null") + ") (audioFormat: " + String.valueOf(this.audioFormat != null ? this.audioFormat : "null") + ")";
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public SLAudioMessage setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public SLAudioMessage setAudioFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public SLAudioMessage setLength(int length) {
        this.length = length;
        return this;
    }

    public String getUniqueStreamId() {
        return this.uniqueStreamId;
    }

    public SLAudioMessage setUniqueStreamId(String uniqueStreamId) {
        this.uniqueStreamId = uniqueStreamId;
        return this;
    }

    public static enum AudioOperation {
        OPEN_FOR_READ,
        CLOSE_READING,
        READ;

    }
}

