/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.operation;

import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.sdo.operation.SLResponse;

public final class PromptSLResponse
extends SLResponse {
    public static final String EVENT_ID = "e.sys.sl.PromptResponse";
    private String userName;
    private String nodeName;
    private String componentType;
    private String componentName;

    public PromptSLResponse() {
    }

    public PromptSLResponse(String userName, String nodeName) {
        super(nodeName);
        this.userName = userName;
        this.nodeName = nodeName;
    }

    public PromptSLResponse(String userName, String nodeName, String componentType, String componentName) {
        this.userName = userName;
        this.nodeName = nodeName;
        this.componentType = componentType;
        this.componentName = componentName;
    }

    public PromptSLResponse(String userName, String nodeName, Exception exception) {
        super(nodeName, exception);
        this.userName = userName;
        this.nodeName = nodeName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setPrompt(String prompt) {
        this.setText(prompt);
    }

    public String getPrompt(boolean isBasic) {
        return isBasic ? this.getText() : PromptSLResponse.formatExtendedPrompt(this.userName, this.nodeName, this.componentType, this.componentName);
    }

    private static String formatExtendedPrompt(String userName, String nodeName, String componentType, String componentName) {
        String prefix = userName + "@";
        if (componentType != null) {
            if (PromptSLResponse.isActivator(componentType) || PromptSLResponse.isDataspace(componentType)) {
                return prefix + nodeName + ":" + componentName;
            }
            return prefix + nodeName + ":" + componentType + "." + componentName;
        }
        return prefix + nodeName;
    }

    private static boolean isActivator(String componentType) {
        return componentType.equalsIgnoreCase("activator");
    }

    private static boolean isDataspace(String componentType) {
        return DataspaceType.equals(componentType);
    }

    @Override
    public String getEventId() {
        return EVENT_ID;
    }
}

