/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.operation;

import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HelpSLResponse
extends SLResponse {
    public static final String EVENT_ID = "e.sys.sl.HelpResponse";
    protected Set<String> contextOperations;
    protected Set<String> foreignOperations;
    protected Set<String> sessionOperations;
    protected Set<String> consoleOperations;
    protected String description;
    protected String otherInfo;
    private static final int CONTEXT = 1;
    private static final int SESSION = 10;
    private static final int CONSOLE = 100;
    private static final int CONTEXT_SESSION = 11;
    private static final int SESSION_CONSOLE = 110;
    private static final int ALL = 111;

    public HelpSLResponse() {
    }

    public HelpSLResponse(Set<String> contextOperations) {
        this.contextOperations = contextOperations;
    }

    public HelpSLResponse(Set<String> contextOperations, Set<String> foreignOperations) {
        this(contextOperations);
        this.foreignOperations = foreignOperations;
    }

    public HelpSLResponse(Set<String> contextOperations, Set<String> foreignOperations, Set<String> sessionOperations) {
        this(contextOperations, foreignOperations);
        this.sessionOperations = sessionOperations;
    }

    public HelpSLResponse(HelpSLResponse response) {
        this.contextOperations = response.contextOperations;
        this.foreignOperations = response.foreignOperations;
        this.sessionOperations = response.sessionOperations;
        this.consoleOperations = response.consoleOperations;
        this.description = response.description;
        this.otherInfo = response.otherInfo;
    }

    public HelpSLResponse(String text, String description, String otherInfo) {
        super(text);
        this.description = description;
        this.otherInfo = otherInfo;
    }

    public HelpSLResponse(String text, boolean isOK) {
        super(text, isOK);
    }

    public Set<String> getContextOperations() {
        return this.contextOperations;
    }

    public HelpSLResponse setContextOperations(Set<String> contextOperations) {
        this.contextOperations = contextOperations;
        return this;
    }

    public Set<String> getForeignOperations() {
        return this.foreignOperations;
    }

    public HelpSLResponse setForeignOperations(Set<String> foreignOperations) {
        this.foreignOperations = foreignOperations;
        return this;
    }

    public Set<String> getSessionOperations() {
        return this.sessionOperations;
    }

    public HelpSLResponse setSessionOperations(Set<String> sessionOperations) {
        this.sessionOperations = sessionOperations;
        return this;
    }

    public Set<String> getConsoleOperations() {
        return this.consoleOperations;
    }

    public HelpSLResponse setConsoleOperations(Set<String> consoleOperations) {
        this.consoleOperations = consoleOperations;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOtherInfo() {
        return this.otherInfo;
    }

    @Override
    public String getEventId() {
        return EVENT_ID;
    }

    private int getResponseType() {
        return this.getRank(this.contextOperations, 1) + this.getRank(this.sessionOperations, 10) + this.getRank(this.consoleOperations, 100);
    }

    private int getRank(Set<String> operations, int rank) {
        return operations != null ? rank : 0;
    }

    public SLResponse convertToUserResponse() {
        if (this.contextOperations != null || this.foreignOperations != null || this.sessionOperations != null || this.consoleOperations != null) {
            int responseType = this.getResponseType();
            RowSet rowSet = new RowSet(this.createResultDescriptor(responseType));
            switch (responseType) {
                case 1: {
                    HelpSLResponse.fillOperations(rowSet, this.getAllContextAndForeignOperations());
                    break;
                }
                case 10: {
                    HelpSLResponse.fillOperations(rowSet, HelpSLResponse.getList(this.sessionOperations));
                    break;
                }
                case 100: {
                    HelpSLResponse.fillOperations(rowSet, HelpSLResponse.getList(this.consoleOperations));
                    break;
                }
                case 11: {
                    HelpSLResponse.fillOperations(rowSet, HelpSLResponse.getList(this.getAllContextAndForeignOperations(), this.sessionOperations));
                    break;
                }
                case 110: {
                    HelpSLResponse.fillOperations(rowSet, HelpSLResponse.getList(this.sessionOperations, this.consoleOperations));
                    break;
                }
                case 111: {
                    HelpSLResponse.fillOperations(rowSet, HelpSLResponse.getList(this.getAllContextAndForeignOperations(), this.sessionOperations, this.consoleOperations));
                }
            }
            return new SLResponse(rowSet);
        }
        return this;
    }

    protected RowMetaData createResultDescriptor(int responseType) {
        RowMetaData result = new RowMetaData();
        switch (responseType) {
            case 1: {
                this.addContextAndForeignColumn(result);
                break;
            }
            case 10: {
                this.addSessionColumn(result);
                break;
            }
            case 100: {
                this.addConsoleColumn(result);
                break;
            }
            case 11: {
                this.addContextAndForeignColumn(result);
                this.addSessionColumn(result);
                break;
            }
            case 110: {
                this.addSessionColumn(result);
                this.addConsoleColumn(result);
                break;
            }
            case 111: {
                this.addContextAndForeignColumn(result);
                this.addSessionColumn(result);
                this.addConsoleColumn(result);
            }
        }
        return result;
    }

    protected void addContextAndForeignColumn(RowMetaData descriptor) {
        this.addContextColumn(descriptor);
        this.addForeignColumn(descriptor);
    }

    protected void addContextColumn(RowMetaData descriptor) {
        descriptor.addColumn(this.getContextColumnName(), SQLType.STRING);
    }

    protected String getContextColumnName() {
        return "Server Commands";
    }

    protected void addForeignColumn(RowMetaData descriptor) {
        if (this.foreignOperations != null) {
            descriptor.addColumn(this.getForeignColumnName(), SQLType.STRING);
        }
    }

    protected String getForeignColumnName() {
        return "Runtime Commands";
    }

    private void addSessionColumn(RowMetaData descriptor) {
        descriptor.addColumn("Session Commands", SQLType.STRING);
    }

    private void addConsoleColumn(RowMetaData descriptor) {
        descriptor.addColumn("Console Commands", SQLType.STRING);
    }

    protected List<Set<String>> getAllContextAndForeignOperations() {
        List<Set<String>> result = this.getAllContextOperations();
        List<Set<String>> allForeignOperations = this.getAllForeignOperations();
        if (allForeignOperations != null) {
            result.addAll(allForeignOperations);
        }
        return result;
    }

    protected List<Set<String>> getAllContextOperations() {
        return HelpSLResponse.getList(this.contextOperations);
    }

    protected List<Set<String>> getAllForeignOperations() {
        return this.foreignOperations != null ? HelpSLResponse.getList(this.foreignOperations) : null;
    }

    protected static List<Set<String>> getList(Set<String> ... operations) {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        Collections.addAll(result, operations);
        return result;
    }

    protected static List<Set<String>> getList(List<Set<String>> result, Set<String> ... operations) {
        if (result == null) {
            result = new ArrayList<Set<String>>();
        }
        Collections.addAll(result, operations);
        return result;
    }

    private static void fillOperations(RowSet rowSet, List<Set<String>> operations) {
        List iters = operations.stream().map(Set::iterator).collect(Collectors.toList());
        int nOperations = operations.stream().map(Set::size).max(Integer::compare).get();
        for (int i = 0; i < nOperations; ++i) {
            ArrayList<String> row = new ArrayList<String>();
            for (int ii = 0; ii < operations.size(); ++ii) {
                row.add(i < operations.get(ii).size() ? (String)((Iterator)iters.get(ii)).next() : "");
            }
            rowSet.addRow(row.toArray());
        }
    }
}

