/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.mf.admin;

import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;

public class PrototypeFactory
extends AbstractFabricContextFactory {
    public static void addAdvisoryPrototype(String model, String eventId) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addAdvisoryPrototype(model, eventId);
    }

    public static void addAdvisoryPrototype(String eventId, AdvisoryEventDatagram event) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addAdvisoryPrototype(eventId, event);
    }

    public static void removeAdvisoryPrototype(String eventId) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        if (context.getDatagramPrototypeFactory().existsEventId(eventId)) {
            context.getDatagramPrototypeFactory().removeAdvisoryPrototype(eventId);
        }
    }

    public static void addEventPrototype(String model, String eventId) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addEventPrototype(model, eventId);
    }

    public static void addEventPrototype(String eventId, EventDatagram event) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addEventPrototype(eventId, event);
    }

    public static void addDataEventPrototype(String eventId, String semanticType) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addDataEventPrototype(eventId, semanticType);
    }

    public static void addDataEventPrototype(String eventId, CloneableDataObject data) throws DatagramFactoryException {
        PrototypeFactory.addDataEventPrototype(eventId, PrototypeFactory.createDataEventPrototype(data));
    }

    public static void addDataEventPrototype(String eventId, DataEvent event) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addDataEventPrototype(eventId, event);
    }

    public static void addDeltaEventPrototype(String eventId, String semanticType) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addDeltaEventPrototype(eventId, semanticType);
    }

    public static void addDeltaEventPrototype(String eventId, CloneableDataObject data) throws DatagramFactoryException {
        PrototypeFactory.addDeltaEventPrototype(eventId, PrototypeFactory.createDeltaEventPrototype(data));
    }

    public static void addDeltaEventPrototype(String eventId, DeltaEvent event) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addDeltaEventPrototype(eventId, event);
    }

    public static void removeEventPrototype(String eventId) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        if (context.getDatagramPrototypeFactory().existsEventId(eventId)) {
            context.getDatagramPrototypeFactory().removeEventPrototype(eventId);
        }
    }

    public static void addOpaqueEventPrototype(String eventId, String semanticType) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addOpaqueEventPrototype(eventId, semanticType);
    }

    public static void addOpaqueEventPrototype(String eventId, CloneableDataObject data) throws DatagramFactoryException {
        PrototypeFactory.addOpaqueEventPrototype(eventId, PrototypeFactory.createOpaqueEventPrototype(data));
    }

    public static void addOpaqueEventPrototype(String eventId, OpaqueEvent event) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addOpaqueEventPrototype(eventId, event);
    }

    public static void removeOpaqueEventPrototype(String eventId) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        if (context.getDatagramPrototypeFactory().existsEventId(eventId)) {
            context.getDatagramPrototypeFactory().removeOpaqueEventPrototype(eventId);
        }
    }

    public static void addExceptionPrototype(String model, String eventId) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addExceptionPrototype(model, eventId);
    }

    public static void addExceptionPrototype(String eventId, ExceptionEventDatagram event) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        context.getDatagramPrototypeFactory().addExceptionPrototype(eventId, event);
    }

    public static void removeExceptionPrototype(String eventId) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        if (context.getDatagramPrototypeFactory().existsEventId(eventId)) {
            context.getDatagramPrototypeFactory().removeExceptionPrototype(eventId);
        }
    }

    public static void removePrototype(String eventId) throws DatagramFactoryException {
        PrototypeFactory.removePrototype(eventId, false);
    }

    public static void removePrototype(String eventId, boolean force) throws DatagramFactoryException {
        PrototypeFactory.checkContext();
        if (context.getDatagramPrototypeFactory().existsEventId(eventId)) {
            context.getDatagramPrototypeFactory().removePrototype(eventId, force);
        }
    }

    public static boolean existsPrototype(String eventId) {
        PrototypeFactory.checkContext();
        return context.getDatagramPrototypeFactory().existsEventId(eventId);
    }

    public static String createInstance(String eventId) {
        return eventId.replace('.', '_');
    }

    public static String createEventId(String instance) {
        return instance.replace('_', '.');
    }

    private static DataEvent createDataEventPrototype(Object data) throws DatagramFactoryException {
        if (!context.getSemanticTypeCache().existsSemanticClass(data.getClass())) {
            PrototypeFactory.addSemanticType(PrototypeFactory.createSemanticType(data));
        }
        try {
            DataEvent result = (DataEvent)PrototypeFactory.createEvent("DataEvent");
            result.setData(data);
            return result;
        }
        catch (Exception exception) {
            throw new DatagramFactoryException(5002, "Setting of data object to DataEvent prototype failed.", exception);
        }
    }

    private static DeltaEvent createDeltaEventPrototype(Object data) throws DatagramFactoryException {
        if (!context.getSemanticTypeCache().existsSemanticClass(data.getClass())) {
            PrototypeFactory.addSemanticType(PrototypeFactory.createSemanticType(data));
        }
        try {
            DeltaEvent result = (DeltaEvent)PrototypeFactory.createEvent("DeltaEvent");
            result.setBeforeImage(data);
            result.setAfterImage(data);
            return result;
        }
        catch (Exception exception) {
            throw new DatagramFactoryException(5002, "Setting of data object to DeltaEvent prototype failed.", exception);
        }
    }

    private static OpaqueEvent createOpaqueEventPrototype(Object data) throws DatagramFactoryException {
        if (!context.getSemanticTypeCache().existsSemanticClass(data.getClass())) {
            PrototypeFactory.addSemanticType(PrototypeFactory.createSemanticType(data));
        }
        try {
            OpaqueEvent result = (OpaqueEvent)context.getOpaqueDatagramFactory().newEventInstance(PrototypeFactory.getSemanticType("OpaqueEvent"));
            result.setData(data);
            return result;
        }
        catch (Exception exception) {
            throw new DatagramFactoryException(5002, "Setting of data object to OpaqueEvent prototype failed.", exception);
        }
    }

    private static EventDatagram createEvent(String model) throws DatagramFactoryException {
        return context.getEventDatagramFactory().newEventInstance(PrototypeFactory.getSemanticType(model));
    }

    private static SemanticType getSemanticType(String model) throws DatagramFactoryException {
        SemanticType semanticType = context.getSemanticTypeCache().lookupSemanticType(model);
        if (semanticType == null) {
            throw new DatagramFactoryException(5014, "Semantic type '" + model + "' does not exist.");
        }
        return semanticType;
    }

    private static void addSemanticType(SemanticType semanticType) throws DatagramFactoryException {
        try {
            TypeFactory.addSemanticType(semanticType);
        }
        catch (SemanticTypeFactoryException exception) {
            throw new DatagramFactoryException(exception.getErrorCode(), (Throwable)exception);
        }
    }

    private static SemanticType createSemanticType(Object dataObject) {
        return PrototypeFactory.createSemanticType(dataObject.getClass());
    }

    private static SemanticType createSemanticType(Class dataClass) {
        return new SemanticType((String)(dataClass.isArray() ? dataClass.getComponentType().getSimpleName() + "-array" : dataClass.getSimpleName()), dataClass.getName());
    }
}

