/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.jms;

import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.jms.Message;
import com.streamscape.sdo.sys.Text;
import javax.jms.JMSException;

public class TextMessage
extends Message
implements javax.jms.TextMessage {
    private Text body = null;

    protected TextMessage() {
    }

    protected TextMessage(String eventId) throws SDOFormatException {
        super(eventId);
    }

    @Override
    public String getText() throws JMSException {
        try {
            this.assertReadAccess();
            return this.body.getText();
        }
        catch (SecurityViolationException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public void setText(String text) throws JMSException {
        try {
            this.assertState();
            this.assertWriteAccess();
            this.body.setText(text);
        }
        catch (SecurityViolationException error) {
            throw new JMSException(error.getMessage());
        }
        catch (SDORuntimeException ex) {
            throw new JMSException(ex.getMessage());
        }
    }
}

