/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.jms;

import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.MessageDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SecurityViolationException;
import java.util.Collections;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;

public class Message
extends IAbstractDataEvent
implements MessageDatagram {
    private String JMSMessageID = null;
    private Destination JMSReplyTo = null;
    private Destination JMSDestination = null;
    private int JMSDeliveryMode = 2;
    private boolean JMSRedelivered = false;
    private String JMSType = null;
    private long JMSExpiration = 0L;
    private int JMSPriority = 4;
    private String JMSXUserID = null;
    private String JMSXAppID = null;
    private int JMSXDeliveryCount = 0;
    private String JMSXGroupID = null;
    private int JMSXGroupSeq = 0;
    private String JMSXProducerTXID = null;
    private String JMSXConsumerTXID = null;
    private long JMSXRcvTimestamp = 0L;
    private int JMSXState = 0;

    protected Message() {
    }

    protected Message(javax.jms.Message message) {
    }

    protected Message(String eventId) throws SDOFormatException {
        super(eventId);
    }

    @Override
    public String getJMSMessageID() {
        return this.JMSMessageID;
    }

    @Override
    public void setJMSMessageID(String jmsMessageId) {
        this.JMSMessageID = jmsMessageId;
    }

    @Override
    public long getJMSTimestamp() {
        return super.getTimeStamp();
    }

    @Override
    public void setJMSTimestamp(long jmsTimestamp) {
        super.setTimeStamp(jmsTimestamp);
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() {
        return super.getCorrelationIdAsBytes();
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] correlationId) {
        super.setCorrelationIdAsBytes(correlationId);
    }

    @Override
    public void setJMSCorrelationID(String correlationId) {
        super.setCorrelationId(correlationId);
    }

    @Override
    public String getJMSCorrelationID() {
        return super.getCorrelationId();
    }

    @Override
    public Destination getJMSReplyTo() {
        return this.JMSReplyTo;
    }

    @Override
    public void setJMSReplyTo(Destination destination) {
        this.JMSReplyTo = destination;
    }

    @Override
    public Destination getJMSDestination() {
        return this.JMSDestination;
    }

    @Override
    public void setJMSDestination(Destination destination) {
        this.JMSDestination = destination;
    }

    @Override
    public int getJMSDeliveryMode() {
        return this.JMSDeliveryMode;
    }

    @Override
    public void setJMSDeliveryMode(int jmsDeliveryMode) {
        this.JMSDeliveryMode = jmsDeliveryMode;
    }

    @Override
    public boolean getJMSRedelivered() {
        return this.JMSRedelivered;
    }

    @Override
    public void setJMSRedelivered(boolean jmsRedelivered) {
        this.JMSRedelivered = jmsRedelivered;
    }

    @Override
    public String getJMSType() {
        return this.JMSType;
    }

    @Override
    public void setJMSType(String jmsType) {
        this.JMSType = jmsType;
    }

    @Override
    public long getJMSExpiration() {
        return this.JMSExpiration;
    }

    @Override
    public void setJMSExpiration(long jmsExpiration) {
        this.JMSExpiration = jmsExpiration;
    }

    @Override
    public int getJMSPriority() {
        return this.JMSPriority;
    }

    @Override
    public void setJMSPriority(int jmsPriority) {
        this.JMSPriority = jmsPriority;
    }

    @Override
    public boolean getBooleanProperty(String name) throws JMSException {
        try {
            Object result = super.getEventObjectProperty(name);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new IllegalStateException("Specified property '" + name + "' is not boolean.");
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public byte getByteProperty(String name) throws JMSException {
        try {
            Object result = super.getEventObjectProperty(name);
            if (result instanceof Byte) {
                return (Byte)result;
            }
            throw new IllegalStateException("Specified property '" + name + "' is not byte.");
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public short getShortProperty(String name) throws JMSException {
        try {
            Object result = super.getEventObjectProperty(name);
            if (result instanceof Short) {
                return (Short)result;
            }
            throw new IllegalStateException("Specified property '" + name + "' is not short.");
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public int getIntProperty(String propertyName) throws JMSException {
        try {
            super.getEventIntProperty(propertyName);
        }
        catch (SDOException sDOException) {
            // empty catch block
        }
        try {
            Object result = super.getEventObjectProperty(propertyName);
            if (result instanceof Integer) {
                return (Integer)result;
            }
            throw new IllegalStateException("Specified property '" + propertyName + "' is not integer.");
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public long getLongProperty(String name) throws JMSException {
        try {
            Object result = super.getEventObjectProperty(name);
            if (result instanceof Long) {
                return (Long)result;
            }
            throw new IllegalStateException("Specified property '" + name + "' is not long.");
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public float getFloatProperty(String name) throws JMSException {
        try {
            Object result = super.getEventObjectProperty(name);
            if (result instanceof Float) {
                return ((Float)result).floatValue();
            }
            throw new IllegalStateException("Specified property '" + name + "' is not float.");
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public double getDoubleProperty(String name) throws JMSException {
        try {
            Object result = super.getEventObjectProperty(name);
            if (result instanceof Double) {
                return (Double)result;
            }
            throw new IllegalStateException("Specified property '" + name + "' is not double.");
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public String getStringProperty(String propertyName) throws JMSException {
        try {
            Object result = super.getEventObjectProperty(propertyName);
            if (result instanceof String) {
                return (String)result;
            }
            return null;
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public void setBooleanProperty(String name, boolean value) throws JMSException {
        try {
            super.setEventObjectProperty(name, value);
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public void setByteProperty(String name, byte value) throws JMSException {
        try {
            super.setEventObjectProperty(name, value);
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public void setShortProperty(String name, short value) throws JMSException {
        try {
            super.setEventObjectProperty(name, value);
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public void setIntProperty(String name, int value) throws JMSException {
        try {
            super.setEventObjectProperty(name, value);
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public void setLongProperty(String name, long value) throws JMSException {
        try {
            super.setEventObjectProperty(name, value);
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public void setFloatProperty(String name, float value) throws JMSException {
        try {
            super.setEventObjectProperty(name, Float.valueOf(value));
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public void setDoubleProperty(String name, double value) throws JMSException {
        try {
            super.setEventObjectProperty(name, value);
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public void setStringProperty(String name, String value) throws JMSException {
        try {
            super.setEventObjectProperty(name, value);
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public void acknowledge() throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearBody() throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearProperties() throws JMSException {
        super.clearEventProperties();
    }

    @Override
    public boolean propertyExists(String propertyName) throws JMSException {
        try {
            return super.existsEventProperty(propertyName);
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public Object getObjectProperty(String name) throws JMSException {
        try {
            return super.getEventObjectProperty(name);
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    public Enumeration<String> getPropertyNames() throws JMSException {
        return Collections.enumeration(super.getEventPropertyNames());
    }

    @Override
    public void setObjectProperty(String name, Object value) throws JMSException {
        try {
            super.setEventObjectProperty(name, value);
        }
        catch (SDOException error) {
            throw new JMSException(error.getMessage());
        }
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return null;
    }
}

