/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.jms;

import com.streamscape.Trace;
import com.streamscape.omf.SerializerSupportException;
import com.streamscape.omf.serializer.SerializerFactory;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.MessageDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.jms.BytesMessage;
import com.streamscape.sdo.jms.MapMessage;
import com.streamscape.sdo.jms.Message;
import com.streamscape.sdo.jms.ObjectMessage;
import com.streamscape.sdo.jms.StreamMessage;
import com.streamscape.sdo.jms.TextMessage;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class JMSMessageFactory
extends IAbstractDatagramFactory {
    private static JMSMessageFactory instance = null;

    protected JMSMessageFactory() {
        super("JMSMessageFactory", "event");
        Trace.logInfo(this, "Instantiated JMS Message factory.");
    }

    @Override
    protected void addDatagramEntries() {
        this.addDatagramEntry(new Message(), "JMS Message type.");
        this.addDatagramEntry(new TextMessage(), "JMS Text Message type.");
        this.addDatagramEntry(new BytesMessage(), "JMS Bytes Message type.");
        this.addDatagramEntry(new MapMessage(), "JMS Map Message type.");
        this.addDatagramEntry(new ObjectMessage(), "JMS Object Message type.");
        this.addDatagramEntry(new StreamMessage(), "JMS Stream Message type.");
    }

    @Override
    public void initSerializer(SerializerFactory factory, String serializerName) throws SerializerSupportException {
        if (factory instanceof XSerializerFactory) {
            XSerializer xserializer = (XSerializer)factory.lookupSerializer(serializerName);
            xserializer.getDefaultsProvider().setFieldDefault("eventSource", byte[].class, IAbstractDataEvent.class, new byte[0]);
            xserializer.getDefaultsProvider().setFieldStringDefault("eventId", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("eventKey", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("eventGroupId", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldDefault("correlationId", byte[].class, IAbstractDataEvent.class, new byte[0]);
            xserializer.getDefaultsProvider().setFieldStringDefault("eventReplyTo", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("principal", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("eventForwardTo", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldDefault("credential", byte[].class, IAbstractDataEvent.class, new byte[0]);
        }
    }

    public static JMSMessageFactory getInstance() {
        if (instance == null) {
            instance = new JMSMessageFactory();
        }
        return instance;
    }

    public javax.jms.Message createMessage(EventDatagram event) throws DatagramFactoryException {
        return null;
    }

    public javax.jms.TextMessage createTextMessage(EventDatagram event) throws DatagramFactoryException {
        return null;
    }

    public javax.jms.BytesMessage createBytesMessage(EventDatagram event) throws DatagramFactoryException {
        return null;
    }

    public javax.jms.MapMessage createMapMessage(EventDatagram event) throws DatagramFactoryException {
        return null;
    }

    public javax.jms.ObjectMessage createObjectMessage(EventDatagram event) throws DatagramFactoryException {
        return null;
    }

    public javax.jms.StreamMessage createStreamMessage(EventDatagram event) throws DatagramFactoryException {
        return null;
    }

    @Override
    public final MessageDatagram createEvent(String protoName) throws DatagramFactoryException {
        if (protoName.equals("Message")) {
            return new Message();
        }
        if (protoName.equals("TextMessage")) {
            return new TextMessage();
        }
        if (protoName.equals("BytesMessage")) {
            return new BytesMessage();
        }
        if (protoName.equals("MapMessage")) {
            return new MapMessage();
        }
        if (protoName.equals("ObjectMessage")) {
            return new ObjectMessage();
        }
        if (protoName.equals("StreamMessage")) {
            return new StreamMessage();
        }
        return null;
    }

    @Override
    public MessageDatagram cloneEvent(ImmutableEventDatagram event) throws DatagramFactoryException {
        return (MessageDatagram)super.cloneEvent(event);
    }

    @Override
    public Message newEventInstance(SemanticType type) throws DatagramFactoryException {
        return (Message)super.newEventInstance(type);
    }

    @Override
    public Message newEventInstance(String semanticType) throws DatagramFactoryException {
        return (Message)super.newEventInstance(semanticType);
    }

    @Override
    public Message newEventInstanceFrom(ImmutableEventDatagram event) throws DatagramFactoryException {
        return (Message)super.newEventInstanceFrom(event);
    }

    @Override
    public Message newEventInstanceFrom(String eventId) throws DatagramFactoryException {
        return (Message)super.newEventInstanceFrom(eventId);
    }

    @Override
    public List<SemanticType> getSupportedTypes() {
        Vector<SemanticType> result = new Vector<SemanticType>();
        this.addSemanticType(Message.class, "JMS Message type.", result);
        this.addSemanticType(TextMessage.class, "JMS Text Message type.", result);
        this.addSemanticType(BytesMessage.class, "JMS Bytes Message type.", result);
        this.addSemanticType(MapMessage.class, "JMS Map Message type.", result);
        this.addSemanticType(ObjectMessage.class, "JMS Object Message type.", result);
        this.addSemanticType(StreamMessage.class, "JMS Stream Message type.", result);
        return result;
    }

    @Override
    protected void loadRegisteredPrototypes() throws DatagramFactoryException, SDOException {
        super.loadRegisteredPrototypes();
    }

    @Override
    protected void addSupportedTypes() throws DatagramFactoryException {
        super.addSupportedTypes();
    }

    public Vector<String> listDefaultPrototypes() {
        Vector<String> defaults = new Vector<String>();
        defaults.add("Message");
        defaults.add("TextMessage");
        defaults.add("BytesMessage");
        defaults.add("MapMessage");
        defaults.add("ObjectMessage");
        defaults.add("StreamMessage");
        Collections.sort(defaults);
        return defaults;
    }
}

