/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.http;

import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HTTPResponseSemanticTypes {
    private final Map<String, Map<String, String>> map;

    public HTTPResponseSemanticTypes(Map<String, Map<String, String>> map) {
        this.map = map;
    }

    public void set(String semanticType) {
        this.set("//", semanticType);
    }

    public void set(String spath, String semanticType) {
        this.set("*", spath, semanticType);
    }

    public void set(String statusCodePattern, String spath, String semanticType) {
        Map<String, String> mapForStatusCode = this.map.get(statusCodePattern = this.trimStatusCodePattern(statusCodePattern));
        if (mapForStatusCode == null) {
            for (String staticCode : this.splitStatusCodes(statusCodePattern)) {
                mapForStatusCode = this.getOrCreateMapForStatusCodeAndRemoveFromCompound(staticCode);
                mapForStatusCode.put(spath, semanticType);
            }
        } else {
            mapForStatusCode.put(spath, semanticType);
        }
    }

    public void set(String statusCode, Map<String, String> responseSemanticTypes) {
        Map<String, String> mapForStatusCode = this.map.get(statusCode = this.trimStatusCodePattern(statusCode));
        if (mapForStatusCode == null) {
            for (String staticCodeSingle : this.splitStatusCodes(statusCode)) {
                mapForStatusCode = this.getOrCreateMapForStatusCodeAndRemoveFromCompound(staticCodeSingle);
                mapForStatusCode.clear();
                mapForStatusCode.putAll(responseSemanticTypes);
            }
        } else {
            mapForStatusCode.clear();
            mapForStatusCode.putAll(responseSemanticTypes);
        }
    }

    public void set(Map<String, String> responseSemanticTypes) {
        this.set("*", responseSemanticTypes);
    }

    public String get() {
        return this.get("//");
    }

    public String get(String spath) {
        return this.get("*", spath);
    }

    public String get(String statusCode, String spath) {
        Pair<String, Map<String, String>> mapForStatusCodePair = this.getMapForStatusCode(statusCode);
        if (mapForStatusCodePair == null) {
            mapForStatusCodePair = this.getMapForStatusCode("*");
        }
        if (mapForStatusCodePair != null) {
            return (String)((Map)mapForStatusCodePair.second).get(spath);
        }
        return null;
    }

    public void remove(String statusCodePattern) {
        if (this.splitStatusCodes(statusCodePattern).size() == 1) {
            this.getOrCreateMapForStatusCodeAndRemoveFromCompound(statusCodePattern);
        }
        this.map.remove(statusCodePattern);
        statusCodePattern = this.trimStatusCodePattern(statusCodePattern);
        this.map.remove(statusCodePattern);
    }

    public void remove(String statusCodePattern, String spath) {
        Map<String, String> mapForStatusCode = null;
        if (this.splitStatusCodes(statusCodePattern).size() == 1) {
            mapForStatusCode = this.getOrCreateMapForStatusCodeAndRemoveFromCompound(statusCodePattern);
            mapForStatusCode.remove(spath);
            if (mapForStatusCode.size() == 0) {
                this.map.remove(this.trimStatusCodePattern(statusCodePattern));
            }
        } else {
            for (String statusCode : this.splitStatusCodes(statusCodePattern)) {
                mapForStatusCode = this.getOrCreateMapForStatusCodeAndRemoveFromCompound(statusCode);
                mapForStatusCode.remove(spath);
                if (mapForStatusCode.size() != 0) continue;
                this.map.remove(statusCode);
            }
        }
    }

    public void removeAll() {
        this.map.clear();
    }

    public Map<String, Map<String, String>> getMap() {
        return new HashMap<String, Map<String, String>>(this.map);
    }

    private Map<String, String> getOrCreateMapForStatusCodeAndRemoveFromCompound(String statusCode) {
        Pair<String, Map<String, String>> mapForStatusCodePair = this.getMapForStatusCode(statusCode = this.trimStatusCodePattern(statusCode));
        if (mapForStatusCodePair == null) {
            HashMap<String, String> mapForStatusCode = new HashMap<String, String>();
            this.map.put(statusCode, mapForStatusCode);
            return mapForStatusCode;
        }
        List<String> mapForStatusCodeCodesList = this.splitStatusCodes((String)mapForStatusCodePair.first);
        if (mapForStatusCodeCodesList.size() == 1) {
            return (Map)mapForStatusCodePair.second;
        }
        this.map.remove(mapForStatusCodePair.second);
        mapForStatusCodeCodesList.remove(statusCode);
        this.map.put(this.joinStatusCodes(mapForStatusCodeCodesList), (Map)mapForStatusCodePair.second);
        HashMap mapForStatusCode = new HashMap((Map)mapForStatusCodePair.second);
        this.map.put(statusCode, mapForStatusCode);
        return new HashMap<String, String>(mapForStatusCode);
    }

    private Pair<String, Map<String, String>> getMapForStatusCode(String statusCode) {
        Map<String, String> mapForStatusCode = this.map.get(statusCode = this.trimStatusCodePattern(statusCode));
        if (mapForStatusCode != null) {
            return new Pair<String, Map<String, String>>(statusCode, mapForStatusCode);
        }
        String finalStatusCode = statusCode;
        Map.Entry entry = this.map.entrySet().stream().filter(e -> this.splitStatusCodes((String)e.getKey()).contains(finalStatusCode)).findAny().orElse(null);
        if (entry != null) {
            return new Pair<String, Map<String, String>>((String)entry.getKey(), (Map)entry.getValue());
        }
        return null;
    }

    private List<String> splitStatusCodes(String statusCodePattern) {
        return StringUtils.split(statusCodePattern, '|').stream().map(s -> s.trim()).collect(Collectors.toList());
    }

    private String joinStatusCodes(List<String> codes) {
        return codes.stream().collect(Collectors.joining("|"));
    }

    private String trimStatusCodePattern(String statusCodePattern) {
        return StringUtils.split(statusCodePattern.trim(), '|').stream().map(s -> s.trim()).collect(Collectors.joining("|"));
    }
}

