/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.http;

import com.fasterxml.jackson.core.JsonParser;
import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonCustomization;
import com.streamscape.omf.json.jackson.MapJsonParser;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.http.HTTPResponseSemanticTypes;
import com.streamscape.sdo.sdrpath.ReferencePathManager;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class HTTPResponse
extends CloneableDataObject {
    protected int statusCode;
    protected String reasonLine = null;
    protected String version = null;
    protected String originalUri = null;
    protected String effectiveUri = null;
    protected byte[] data = null;
    protected Map<String, String> headers = null;
    protected Map<String, String> trailers = null;
    protected HTTPResponseSemanticTypes responseSemanticTypes;
    protected String deserializerProperties = "notation=type;level=none;prettyprint=false";
    protected String responseCharsetName;
    private transient JsonCustomization deserializerCustomization;

    public HTTPResponse() {
    }

    public HTTPResponse(HTTPRequest request) {
        this.responseSemanticTypes = request.getResponseSemanticTypes();
        this.deserializerProperties = request.getDeserializerProperties();
        this.responseCharsetName = request.getResponseCharsetName();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getReasonLine() {
        return this.reasonLine;
    }

    public void setReasonLine(String reasonLine) {
        this.reasonLine = reasonLine;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getOriginalUri() {
        return this.originalUri;
    }

    public void setOriginalUri(String originalUri) {
        this.originalUri = originalUri;
    }

    public String getEffectiveUri() {
        return this.effectiveUri;
    }

    public void setEffectiveUri(String effectiveUri) {
        this.effectiveUri = effectiveUri;
    }

    public HTTPResponseSemanticTypes getResponseSemanticTypes() {
        return this.responseSemanticTypes;
    }

    public void setResponseSemanticTypes(HTTPResponseSemanticTypes responseSemanticTypes) {
        this.responseSemanticTypes = responseSemanticTypes;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getDataString() throws UnsupportedEncodingException {
        return this.getDataString(this.responseCharsetName);
    }

    public String getDataString(String charsetName) throws UnsupportedEncodingException {
        return this.data != null ? (charsetName != null ? new String(this.data, charsetName) : new String(this.data, StandardCharsets.UTF_8)) : null;
    }

    public Object getDataObject() throws UnsupportedEncodingException, SerializerException {
        return this.getDataObject("//");
    }

    public Object getDataObject(String spath) throws UnsupportedEncodingException, SerializerException {
        String semanticType;
        JSONSerializer serializer = HTTPUtils.getJsonSerializerForRest((FabricContext)RuntimeContext.getInstance(), this.getDeserializerCustomization());
        if (spath == null || !spath.startsWith("//")) {
            throw new IllegalArgumentException("Invalid spath. Should start with '//'.");
        }
        String string = semanticType = this.responseSemanticTypes != null ? this.responseSemanticTypes.get(String.valueOf(this.statusCode), spath) : null;
        if (spath.equals("//")) {
            if (semanticType != null) {
                return serializer.deserialize(semanticType, this.getDataString());
            }
            return serializer.deserialize(this.getDataString());
        }
        Map map = serializer.deserialize(Map.class, this.getDataString());
        Pair<String, Object> pair = this.getValueFromMapBySpath(spath, map);
        if (pair.first != null) {
            semanticType = (String)pair.first;
        }
        if ("string".equals(semanticType)) {
            return serializer.serialize(pair.second);
        }
        if (pair.second instanceof Map) {
            MapJsonParser parser = new MapJsonParser((Map)pair.second);
            if (semanticType != null) {
                return serializer.deserialize(semanticType, (JsonParser)parser);
            }
            return serializer.deserialize(parser);
        }
        if (pair.second instanceof List) {
            String json = serializer.serialize(pair.second);
            if (semanticType != null) {
                return serializer.deserialize(semanticType, json);
            }
            return serializer.deserialize(json);
        }
        return pair.second;
    }

    private Pair<String, Object> getValueFromMapBySpath(String spath, Map map) {
        String token;
        StringTokenizer tokenizer = new StringTokenizer(spath.substring(2), "/");
        Pair<Object, Object> result = new Pair<Object, Map>(null, map);
        Object processedSpath = "/";
        while (tokenizer.hasMoreTokens() && (result = this.getValueFromMapBySpathSegment(token = tokenizer.nextToken(), (String)(processedSpath = (String)processedSpath + "/" + token), result.second)) != null) {
        }
        return result;
    }

    private Pair<String, Object> getValueFromMapBySpathSegment(String sdr, String processedSpath, Object value) {
        if (value == null) {
            return null;
        }
        ReferencePathManager.SdrInfo info = ReferencePathManager.parseSdr(sdr);
        if ((info.fieldName != null || info.isMapKey || info.isMapValue) && !(value instanceof Map)) {
            throw new IllegalArgumentException("Cannot get spath '" + processedSpath + "' on object of type " + value.getClass().getName() + "'. Should be a Map.");
        }
        if (info.fieldName != null) {
            value = ((Map)value).get(info.fieldName);
        }
        if (info.isMapKey) {
            value = ((Map)value).get(info.index);
        } else if (info.isMapValue) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Map.Entry mapEntry = entry;
                if (!mapEntry.getValue().toString().equals(info.index)) continue;
                value = mapEntry.getKey();
                break;
            }
        } else if (info.index != null) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Cannot get spath '" + processedSpath + "' on object of type " + value.getClass().getName() + "'. Should be a List.");
            }
            Integer index = Integer.valueOf(info.index);
            if (((List)value).size() < index) {
                throw new IllegalArgumentException("Cannot get spath '" + processedSpath + "'. Index out of range");
            }
            value = ((List)value).get(index);
        }
        return new Pair<String, Object>(info.fieldSemanticType, value);
    }

    public void setDeserializerProperties(String deserializerProperties) {
        this.deserializerCustomization = HTTPRequest.initCustomization(this.deserializerCustomization, deserializerProperties);
        this.deserializerProperties = deserializerProperties;
    }

    public void setResponseCharsetName(String responseCharsetName) {
        Charset.forName(responseCharsetName);
        this.responseCharsetName = responseCharsetName;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String header, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(header, value);
    }

    public Map<String, String> getTrailers() {
        return this.trailers;
    }

    public void addTrailer(String trailer, String value) {
        if (this.trailers == null) {
            this.trailers = new HashMap<String, String>();
        }
        this.trailers.put(trailer, value);
    }

    public String toString() {
        return this.getVersion() + " " + this.getStatusCode() + " " + this.getReasonLine() + " " + this.getEffectiveUri();
    }

    private JsonCustomization getDeserializerCustomization() {
        this.deserializerCustomization = HTTPRequest.initCustomization(this.deserializerCustomization, this.deserializerProperties);
        return this.deserializerCustomization;
    }
}

