/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.http;

import com.streamscape.sdo.http.HTTPRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class HTTPRequestTemplate {
    private HTTPRequest request;
    private boolean isCompiled = false;
    private StringTemplate uriTemplate = null;
    private StringTemplate dataTemplate = null;
    private Map<String, StringTemplate> queryParametersTemplate = null;
    private Map<String, StringTemplate> formParametersTemplate = null;
    private Map<String, StringTemplate> headersTemplate = null;
    private Map<String, StringTemplate> cookiesTemplate = null;
    private Set<String> templatesParameterNames = null;
    private Map<String, String> parametersMap = null;

    public HTTPRequestTemplate(HTTPRequest request) {
        this.request = request;
    }

    public void setParameterValue(String name, String value) throws HTTPRequestException {
        this.compile();
        if (this.templatesParameterNames == null || !this.templatesParameterNames.contains(name)) {
            throw new HTTPRequestException("Unknown parameter name '" + name + "'.");
        }
        if (this.parametersMap == null) {
            this.parametersMap = new HashMap<String, String>();
        }
        this.parametersMap.put(name, value);
    }

    public void setParameterValues(Map<String, String> parameterValues) throws HTTPRequestException {
        for (Map.Entry<String, String> entry : parameterValues.entrySet()) {
            this.setParameterValue(entry.getKey(), entry.getValue());
        }
    }

    public HTTPRequest customize() throws HTTPRequestException {
        if (this.uriTemplate != null || this.dataTemplate != null || this.queryParametersTemplate != null || this.formParametersTemplate != null || this.headersTemplate != null || this.cookiesTemplate != null) {
            HTTPRequest customizedRequest = (HTTPRequest)this.request.clone();
            if (this.uriTemplate != null) {
                customizedRequest.setUri(this.uriTemplate.resolve(this.parametersMap));
            }
            if (this.dataTemplate != null) {
                customizedRequest.setData(this.dataTemplate.resolve(this.parametersMap));
            }
            if (this.queryParametersTemplate != null) {
                for (Map.Entry<String, StringTemplate> entry : this.queryParametersTemplate.entrySet()) {
                    customizedRequest.setQueryParameter(entry.getKey(), entry.getValue().resolve(this.parametersMap));
                }
            }
            if (this.formParametersTemplate != null) {
                for (Map.Entry<String, StringTemplate> entry : this.formParametersTemplate.entrySet()) {
                    customizedRequest.setFormParameter(entry.getKey(), entry.getValue().resolve(this.parametersMap));
                }
            }
            if (this.headersTemplate != null) {
                for (Map.Entry<String, StringTemplate> entry : this.headersTemplate.entrySet()) {
                    customizedRequest.setHeader(entry.getKey(), entry.getValue().resolve(this.parametersMap));
                }
            }
            if (this.cookiesTemplate != null) {
                for (Map.Entry<String, StringTemplate> entry : this.cookiesTemplate.entrySet()) {
                    customizedRequest.setCookie(entry.getKey(), entry.getValue().resolve(this.parametersMap));
                }
            }
            return customizedRequest;
        }
        return this.request;
    }

    public Set<String> getTemplatesParameterNames() {
        this.compile();
        return this.templatesParameterNames != null ? new TreeSet<String>(this.templatesParameterNames) : new TreeSet();
    }

    private void compile() {
        if (this.isCompiled) {
            return;
        }
        this.uriTemplate = this.compileTemplate(this.request.getUri(), true);
        if (this.request.getData() instanceof String) {
            this.dataTemplate = this.compileTemplate(this.request.getDataString(), false);
        }
        this.queryParametersTemplate = this.compileMap(this.request.getQueryParameters());
        this.formParametersTemplate = this.compileMap(this.request.getFormParameters());
        this.headersTemplate = this.compileMap(this.request.getHeaders());
        this.cookiesTemplate = this.compileMap(this.request.getCookies());
        this.isCompiled = true;
    }

    private Map<String, StringTemplate> compileMap(Map<String, String> map) {
        HashMap<String, StringTemplate> result = null;
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                StringTemplate template = this.compileTemplate(entry.getValue(), false);
                if (template == null) continue;
                if (result == null) {
                    result = new HashMap<String, StringTemplate>();
                }
                result.put(entry.getKey(), template);
            }
        }
        return result;
    }

    private StringTemplate compileTemplate(String value, boolean isUri) {
        if (value == null || value.length() == 0) {
            return null;
        }
        StringTemplate result = null;
        int startPos = 0;
        while (startPos < value.length()) {
            int pos1;
            int endPos = -1;
            boolean uriParamStyle = false;
            int pos = value.indexOf("{%%", startPos);
            if (isUri && (pos1 = value.indexOf("{", startPos)) != -1 && (pos == -1 || pos1 < pos)) {
                pos = pos1;
                endPos = value.indexOf("}", pos);
                uriParamStyle = true;
            }
            if (pos != -1 && !uriParamStyle) {
                endPos = value.indexOf("%%}", pos);
            }
            if (endPos != -1) {
                if (result == null) {
                    result = new StringTemplate(this);
                }
                if (pos > startPos) {
                    result.addPart(new StringPart(this, value.substring(startPos, pos)));
                }
                result.addPart(ParameterPart.create(value.substring(pos + (uriParamStyle ? 1 : 3), endPos)));
                startPos = endPos + (uriParamStyle ? 1 : 3);
                continue;
            }
            if (result != null) {
                result.addPart(new StringPart(this, value.substring(startPos)));
            }
            startPos = value.length();
        }
        this.addTemplateParameterNames(result);
        return result;
    }

    private void addTemplateParameterNames(StringTemplate template) {
        if (template != null) {
            if (this.templatesParameterNames == null) {
                this.templatesParameterNames = new TreeSet<String>();
            }
            this.templatesParameterNames.addAll(template.getParameterNames());
        }
    }

    public static String uriParameterTemplate(String name) {
        return "{" + name + "}";
    }

    public static String parameterTemplate(String name) {
        return "{@@" + name + "@@}";
    }

    public UserParameterContext getTemplateParameterContext(String parameterName) {
        if (this.templateContainsParameterName(this.uriTemplate, parameterName)) {
            return UserParameterContext.URI;
        }
        if (this.templateContainsParameterName(this.dataTemplate, parameterName)) {
            return UserParameterContext.BODY;
        }
        if (this.templateContainsParameterName(this.queryParametersTemplate, parameterName)) {
            return UserParameterContext.QUERY;
        }
        if (this.templateContainsParameterName(this.formParametersTemplate, parameterName)) {
            return UserParameterContext.FORM;
        }
        if (this.templateContainsParameterName(this.headersTemplate, parameterName)) {
            return UserParameterContext.HEADER;
        }
        if (this.templateContainsParameterName(this.cookiesTemplate, parameterName)) {
            return UserParameterContext.COOKIE;
        }
        return UserParameterContext.UNKNOWN;
    }

    public Optional<String> getTemplateParameterDefaultValue(String parameterName) {
        switch (this.getTemplateParameterContext(parameterName).ordinal()) {
            case 0: {
                return this.getTemplateParameterDefaultValue(parameterName, this.uriTemplate);
            }
            case 1: {
                return this.getTemplateParameterDefaultValue(parameterName, this.dataTemplate);
            }
            case 2: {
                return this.getTemplateParameterDefaultValue(parameterName, this.queryParametersTemplate);
            }
            case 3: {
                return this.getTemplateParameterDefaultValue(parameterName, this.formParametersTemplate);
            }
            case 4: {
                return this.getTemplateParameterDefaultValue(parameterName, this.headersTemplate);
            }
        }
        return null;
    }

    private Optional<String> getTemplateParameterDefaultValue(String parameterName, StringTemplate stringTemplate) {
        return stringTemplate.parts.stream().filter(p -> p instanceof ParameterPart && ((ParameterPart)p).getName().equals(parameterName)).map(p -> Optional.ofNullable(((ParameterPart)p).getDefaultValue())).findFirst().orElse(Optional.empty());
    }

    private Optional<String> getTemplateParameterDefaultValue(String parameterName, Map<String, StringTemplate> mapStringTemplate) {
        return mapStringTemplate.values().stream().map(t -> this.getTemplateParameterDefaultValue(parameterName, (StringTemplate)t)).filter(v -> v.isPresent()).findFirst().orElse(Optional.empty());
    }

    private boolean templateContainsParameterName(Map<String, StringTemplate> templates, String parameterName) {
        return templates != null && templates.values().stream().anyMatch(t -> this.templateContainsParameterName((StringTemplate)t, parameterName));
    }

    private boolean templateContainsParameterName(StringTemplate template, String parameterName) {
        return template != null && template.getParameterNames().contains(parameterName);
    }

    class StringTemplate {
        private List<TemplatePart> parts = new ArrayList<TemplatePart>();
        private Set<String> parameterNames = new TreeSet<String>();

        StringTemplate(HTTPRequestTemplate this$0) {
        }

        void addPart(TemplatePart part) {
            this.parts.add(part);
            if (part instanceof ParameterPart) {
                this.parameterNames.add(((ParameterPart)part).getName());
            }
        }

        Set<String> getParameterNames() {
            return this.parameterNames;
        }

        public String resolve(Map<String, String> parametersMap) throws HTTPRequestException {
            if (this.parts.size() == 1 && this.parts.get(0) instanceof StringPart) {
                return ((StringPart)this.parts.get(0)).getValue();
            }
            boolean defaultValueIsEmpty = false;
            StringBuilder builder = new StringBuilder();
            for (TemplatePart part : this.parts) {
                String parameterValue;
                if (part instanceof StringPart) {
                    builder.append(((StringPart)part).getValue());
                    continue;
                }
                String parameterName = ((ParameterPart)part).getName();
                String string = parameterValue = parametersMap != null ? parametersMap.get(parameterName) : null;
                if (parameterValue == null && (parameterValue = ((ParameterPart)part).getDefaultValue()) != null && parameterValue.length() == 0) {
                    defaultValueIsEmpty = true;
                }
                if (parameterValue == null) {
                    throw new HTTPRequestException("Parameter '" + parameterName + "' value is not set.");
                }
                builder.append(parameterValue);
            }
            if (defaultValueIsEmpty && builder.length() == 0 && this.parts.size() == 1) {
                return null;
            }
            return builder.toString();
        }
    }

    public static class HTTPRequestException
    extends Exception {
        public HTTPRequestException(String message) {
            super(message);
        }
    }

    class StringPart
    implements TemplatePart {
        private String value;

        public StringPart(HTTPRequestTemplate this$0, String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    static interface TemplatePart {
    }

    static class ParameterPart
    implements TemplatePart {
        private String name;
        private String defaultValue;

        public ParameterPart(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public static ParameterPart create(String name) {
            int colonIndex = name.indexOf(":");
            if (colonIndex != -1) {
                return new ParameterPart(name.substring(0, colonIndex), name.substring(colonIndex + 1));
            }
            return new ParameterPart(name, null);
        }
    }

    public static enum UserParameterContext {
        URI,
        BODY,
        QUERY,
        FORM,
        HEADER,
        COOKIE,
        UNKNOWN;

    }
}

