/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.http;

import com.streamscape.Trace;
import com.streamscape.omf.json.jackson.JsonCustomization;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.http.HTTPRequestTemplate;
import com.streamscape.sdo.http.HTTPResponseSemanticTypes;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HTTPRequest
extends CloneableDataObject {
    protected String method = null;
    protected String uri = null;
    protected byte[] dataBytes = null;
    protected String dataString = null;
    protected int timeout = 0;
    protected Map<String, String> queryParameters = null;
    protected Map<String, String> formParameters = null;
    protected Map<String, String> headers = null;
    protected Map<String, String> cookies = null;
    protected String requestSemanticType = null;
    protected String serializerProperties = "notation=type;level=none;prettyprint=false";
    protected String requestCharsetName;
    protected Map<String, Map<String, String>> responseSemanticTypes = new HashMap<String, Map<String, String>>();
    protected String deserializerProperties = "notation=type;level=none";
    protected String responseCharsetName;
    private transient JsonCustomization serializerCustomization = null;
    private transient JsonCustomization deserializerCustomization = null;
    private transient HTTPRequestTemplate template = null;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Object getData() {
        return this.dataBytes != null ? this.dataBytes : (byte[])this.dataString;
    }

    public byte[] getDataBytes() {
        try {
            return this.getDataBytes(this.requestCharsetName);
        }
        catch (HTTPRequestTemplate.HTTPRequestException exception) {
            Trace.logException(this, exception, true);
            return null;
        }
    }

    public byte[] getDataBytes(String charsetName) throws HTTPRequestTemplate.HTTPRequestException {
        if (this.dataBytes != null) {
            return this.dataBytes;
        }
        if (this.dataString != null) {
            if (charsetName != null) {
                try {
                    return this.dataString.getBytes(charsetName);
                }
                catch (UnsupportedEncodingException exception) {
                    throw new HTTPRequestTemplate.HTTPRequestException("Invalid charset. Cause: " + exception.getMessage());
                }
            }
            return this.dataString.getBytes();
        }
        return null;
    }

    public String getDataString() {
        try {
            return this.getDataString(this.requestCharsetName);
        }
        catch (HTTPRequestTemplate.HTTPRequestException exception) {
            Trace.logException(this, exception, true);
            return null;
        }
    }

    public String getDataString(String charsetName) throws HTTPRequestTemplate.HTTPRequestException {
        if (this.dataString != null) {
            return this.dataString;
        }
        if (this.dataBytes != null) {
            if (charsetName != null) {
                try {
                    return new String(this.dataBytes, charsetName);
                }
                catch (UnsupportedEncodingException exception) {
                    throw new HTTPRequestTemplate.HTTPRequestException("Invalid charset. Cause: " + exception.getMessage());
                }
            }
            return new String(this.dataBytes);
        }
        return null;
    }

    public void setData(byte[] data) {
        this.dataBytes = data;
        this.dataString = null;
    }

    public void setData(String data) {
        this.dataBytes = null;
        this.dataString = data;
    }

    public void setDataObject(Object object) throws SerializerException {
        this.dataString = HTTPUtils.getJsonSerializerForRest((FabricContext)RuntimeContext.getInstance(), this.getSerializerCustomization()).serialize(object);
        this.dataBytes = null;
    }

    public void setSerializerProperties(String serializerProperties) {
        this.serializerCustomization = HTTPRequest.initCustomization(this.serializerCustomization, serializerProperties);
        this.serializerProperties = serializerProperties;
    }

    public String getSerializerProperties() {
        if (this.serializerProperties == null) {
            this.serializerProperties = "notation=type;level=none;prettyprint=false";
        }
        return this.serializerProperties;
    }

    public void setDeserializerProperties(String deserializerProperties) {
        this.deserializerCustomization = HTTPRequest.initCustomization(this.deserializerCustomization, deserializerProperties);
        this.deserializerProperties = deserializerProperties;
    }

    public String getDeserializerProperties() {
        if (this.deserializerProperties == null) {
            this.deserializerProperties = "notation=type;level=none";
        }
        return this.deserializerProperties;
    }

    public String getRequestCharsetName() {
        return this.requestCharsetName;
    }

    public void setRequestCharsetName(String requestCharsetName) throws HTTPRequestTemplate.HTTPRequestException {
        try {
            Charset.forName(requestCharsetName);
            this.requestCharsetName = requestCharsetName;
        }
        catch (Exception exception) {
            throw new HTTPRequestTemplate.HTTPRequestException("Invalid charset. Cause: " + exception.getMessage());
        }
    }

    public String getResponseCharsetName() {
        return this.responseCharsetName;
    }

    public void setResponseCharsetName(String responseCharsetName) throws HTTPRequestTemplate.HTTPRequestException {
        try {
            Charset.forName(responseCharsetName);
            this.responseCharsetName = responseCharsetName;
        }
        catch (Exception exception) {
            throw new HTTPRequestTemplate.HTTPRequestException("Invalid charset. Cause: " + exception.getMessage());
        }
    }

    public HTTPResponseSemanticTypes getResponseSemanticTypes() {
        if (this.responseSemanticTypes == null) {
            this.responseSemanticTypes = new HashMap<String, Map<String, String>>();
        }
        return new HTTPResponseSemanticTypes(this.responseSemanticTypes);
    }

    public void setResponseSemanticTypes(HTTPResponseSemanticTypes responseSemanticTypes) {
        this.responseSemanticTypes = responseSemanticTypes.getMap();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void setQueryParameter(String name, String value) {
        if (this.queryParameters == null) {
            this.queryParameters = new HashMap<String, String>();
        }
        this.setValueOrRemove(this.queryParameters, name, value);
    }

    public void addQueryParameter(String name, String value) {
        if (this.queryParameters == null) {
            this.queryParameters = new HashMap<String, String>();
        }
        this.queryParameters.put(name, value);
    }

    public Map<String, String> getFormParameters() {
        return this.formParameters;
    }

    public void setFormParameters(Map<String, String> formParameters) {
        this.formParameters = formParameters;
    }

    public void setFormParameter(String name, String value) {
        if (this.formParameters == null) {
            this.formParameters = new HashMap<String, String>();
        }
        this.setValueOrRemove(this.formParameters, name, value);
    }

    public void addFormParameter(String name, String value) {
        if (this.formParameters == null) {
            this.formParameters = new HashMap<String, String>();
        }
        this.formParameters.put(name, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        this.setValueOrRemove(this.headers, name, value);
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public void addCookie(String name, String value) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(name, value);
    }

    public void setCookie(String name, String value) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(name, value);
        this.setValueOrRemove(this.cookies, name, value);
    }

    public String toString() {
        return "HTTPRequest method: " + this.method + ", uri: " + this.uri + ", query parameters: " + String.valueOf(this.queryParameters) + ", header: " + String.valueOf(this.headers) + ", data: " + this.getDataString();
    }

    public void setParameterValue(String name, String value) throws HTTPRequestTemplate.HTTPRequestException {
        if (this.template == null) {
            this.template = new HTTPRequestTemplate(this);
        }
        this.template.setParameterValue(name, value);
    }

    public void setParameterValues(Map<String, String> parameterValues) throws HTTPRequestTemplate.HTTPRequestException {
        if (this.template == null) {
            this.template = new HTTPRequestTemplate(this);
        }
        this.template.setParameterValues(parameterValues);
    }

    public HTTPRequestTemplate getTemplate() throws HTTPRequestTemplate.HTTPRequestException {
        if (this.template == null) {
            this.template = new HTTPRequestTemplate(this);
        }
        return this.template;
    }

    public HTTPRequest customize() throws HTTPRequestTemplate.HTTPRequestException {
        if (this.template == null) {
            return this;
        }
        return this.template.customize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HTTPRequest)) {
            return false;
        }
        HTTPRequest request = (HTTPRequest)o;
        return this.timeout == request.timeout && Objects.equals(this.method, request.method) && Objects.equals(this.uri, request.uri) && Objects.equals(this.dataBytes, request.dataBytes) && Objects.equals(this.dataString, request.dataString) && Objects.equals(this.queryParameters, request.queryParameters) && Objects.equals(this.headers, request.headers) && Objects.equals(this.template, request.template);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.uri, this.dataBytes, this.dataString, this.timeout, this.queryParameters, this.headers, this.template);
    }

    private JsonCustomization getSerializerCustomization() {
        this.serializerCustomization = HTTPRequest.initCustomization(this.serializerCustomization, this.getSerializerProperties());
        return this.serializerCustomization;
    }

    private JsonCustomization getDeserializerCustomization() {
        this.deserializerCustomization = HTTPRequest.initCustomization(this.deserializerCustomization, this.getDeserializerProperties());
        return this.deserializerCustomization;
    }

    static JsonCustomization initCustomization(JsonCustomization customization, String properties) {
        if (customization == null && properties != null) {
            customization = properties != null ? JsonCustomization.builder().fromString(properties).build() : JsonCustomization.builder().build();
        }
        return customization;
    }

    public void setRequestSemanticType(String requestSemanticType) {
        this.requestSemanticType = requestSemanticType;
    }

    public String getRequestSemanticType() {
        return this.requestSemanticType;
    }

    private void setValueOrRemove(Map<String, String> parameters, String name, String value) {
        if (value != null) {
            parameters.put(name, value);
        } else {
            parameters.remove(name);
        }
    }
}

