/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.file;

import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.enums.FileEventType;
import com.streamscape.sdo.enums.FileState;
import java.io.File;
import java.util.Date;

public class FileMetaInfo
extends CloneableDataObject {
    protected String name;
    protected String path;
    protected long date;
    protected FileState state;
    protected FileEventType eventType;
    protected long size;
    protected String absoluteFileName;
    protected String relativeFileName;
    protected long sizeDelta;
    protected boolean isDirectory;
    private transient String normalizedPath;

    public FileMetaInfo(File file) {
        this(file, FileState.STATIC);
    }

    public FileMetaInfo(File file, FileState state) {
        this.path = file.getPath();
        this.size = file.length();
        this.name = file.getName();
        this.date = file.lastModified();
        this.absoluteFileName = file.getAbsolutePath();
        this.sizeDelta = 0L;
        this.isDirectory = file.isDirectory();
        this.setLastState(state);
    }

    public FileMetaInfo(File file, FileState state, long sizeDelta) {
        this(file, state);
        this.sizeDelta = sizeDelta;
    }

    public FileMetaInfo(FileInfo fileInfo) {
        this.path = fileInfo.getPath();
        this.size = fileInfo.getSize();
        this.name = fileInfo.getName();
        this.date = fileInfo.getModificationTime();
        this.absoluteFileName = fileInfo.getAbsolutePath();
        this.sizeDelta = 0L;
        this.isDirectory = fileInfo.isDirectory();
        this.setLastState(FileState.STATIC);
    }

    public String getPath() {
        if (this.normalizedPath == null) {
            this.normalizedPath = this.path.replace('\\', '/');
        }
        return this.normalizedPath;
    }

    public String getName() {
        return this.name;
    }

    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    public void setRelativeFileName(String fileName) {
        this.relativeFileName = fileName;
    }

    public long getLastModifiedTime() {
        return this.date;
    }

    public Date getLastModifiedAsDate() {
        return new Date(this.date);
    }

    public void setLastModifiedTime(Date ts) {
        this.date = ts.getTime();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public FileState getLastState() {
        return this.state;
    }

    public synchronized void setLastState(FileState state) {
        this.state = state;
        this.setEventType(FileEventType.FILE_STATE_CHANGED);
    }

    public void setEventType(FileEventType eventType) {
        this.eventType = eventType;
    }

    public String getAbsoluteFileName() {
        return this.absoluteFileName;
    }

    public FileEventType getEventType() {
        return this.eventType;
    }

    public long getSizeDelta() {
        return this.sizeDelta;
    }

    public void setSizeDelta(long sizeDelta) {
        this.sizeDelta = sizeDelta;
    }

    protected FileMetaInfo() {
    }

    public boolean equals(Object other) {
        return this == other || other instanceof FileMetaInfo && this.path.equals(((FileMetaInfo)other).path);
    }

    public String toString() {
        return "FileMetaInfo{name='" + this.name + "', path='" + this.path + "', date=" + this.date + ", state=" + String.valueOf((Object)this.state) + ", size=" + this.size + ", isDirectory=" + this.isDirectory + "}";
    }
}

