/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.excp;

import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.excp.ValidationError;
import java.util.ArrayList;
import java.util.List;

public class ValidationException
extends IAbstractExceptionEvent {
    public static final String EVENT_ID = "exception.Validation";
    private List<ValidationError> errors = new ArrayList<ValidationError>();

    public ValidationException(int errorCode, String message) {
        super(errorCode, message);
    }

    public ValidationException(int errorCode, Throwable cause) {
        super(errorCode, cause);
    }

    public ValidationException(int errorCode, String message, Throwable cause) {
        super(errorCode, message, cause);
    }

    public ValidationException(int errorCode, String message, Severity severity) {
        super(errorCode, message, severity);
    }

    public ValidationException(int errorCode, Throwable cause, Severity severity) {
        super(errorCode, cause, severity);
    }

    public ValidationException(int errorCode, String message, Throwable cause, Severity severity) {
        super(errorCode, message, cause, severity);
    }

    public void addError(String name, String value) {
        this.errors.add(new ValidationError(name, value));
    }

    public List<ValidationError> getErrors() {
        return new ArrayList<ValidationError>(this.errors);
    }

    public String getFullMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMessage()).append("\n");
        for (ValidationError error : this.errors) {
            builder.append(error.name + " : " + error.value).append("\n");
        }
        return builder.toString();
    }

    protected ValidationException() {
    }

    protected ValidationException(String message) {
        super(message);
    }

    @Override
    protected void init() {
        this.eventId = EVENT_ID;
        this.errPrefix = "SVC";
    }

    @Override
    protected String getPrefix() {
        return "Service Validation Exception";
    }
}

