/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.excp;

import com.streamscape.Trace;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.Severity;
import java.sql.SQLException;

public class LanguageException
extends IAbstractExceptionEvent {
    public static final String EVENT_ID = "exception.Language";
    public static final String TYPE_SQL = "sql";
    public static final String TYPE_SCRIPT = "script";
    public static final String TYPE_PROPERTY = "type";
    public static final String NAME_PROPERTY = "name";
    private Exception originalException;

    public LanguageException(int errorCode, String message) {
        super(errorCode, message);
    }

    public LanguageException(int errorCode, Throwable cause) {
        super(errorCode, cause);
    }

    public LanguageException(int errorCode, String message, Throwable cause) {
        super(errorCode, message, cause);
    }

    public LanguageException(int errorCode, String message, Severity severity) {
        super(errorCode, message, severity);
    }

    public LanguageException(int errorCode, Throwable cause, Severity severity) {
        super(errorCode, cause, severity);
    }

    public LanguageException(int errorCode, String message, Throwable cause, Severity severity) {
        super(errorCode, message, cause, severity);
    }

    protected LanguageException() {
    }

    protected LanguageException(String message) {
        super(message);
    }

    public String getType() throws SecurityViolationException, SDOException {
        this.assertState();
        return (String)this.getEventObjectProperty(TYPE_PROPERTY);
    }

    public void setType(String type) throws SecurityViolationException, SDOException {
        this.assertState();
        this.setProperty(TYPE_PROPERTY, type);
    }

    public String getName() throws SecurityViolationException, SDOException {
        this.assertState();
        return (String)this.getEventObjectProperty(NAME_PROPERTY);
    }

    public void setName(String name) throws SecurityViolationException, SDOException {
        this.assertState();
        this.setProperty(NAME_PROPERTY, name);
    }

    @Override
    protected void init() {
        this.initProperties();
        this.eventId = EVENT_ID;
        this.errPrefix = "Language";
    }

    protected void initProperties() {
        try {
            this.setType(TYPE_SCRIPT);
        }
        catch (Exception exception) {
            throw new SDORuntimeException("Adding property 'type' failed.", exception);
        }
        try {
            this.setName("");
        }
        catch (Exception exception) {
            throw new SDORuntimeException("Adding property 'name' failed.", exception);
        }
    }

    @Override
    protected String getPrefix() {
        return "Language script execution exception";
    }

    public Exception getOriginalException() {
        return this.originalException;
    }

    public static LanguageException create(Exception exception) {
        Throwable cause;
        String type = TYPE_SCRIPT;
        Exception previousCause = null;
        for (cause = exception; cause != previousCause && cause != null; cause = cause.getCause()) {
            if (cause instanceof SQLException) {
                type = TYPE_SQL;
                break;
            }
            previousCause = cause;
        }
        if (cause == null) {
            cause = exception;
        }
        LanguageException languageException = new LanguageException(6000, exception.getMessage(), cause);
        languageException.originalException = exception;
        try {
            languageException.setType(type);
            languageException.setName(cause.getClass().getName());
        }
        catch (Exception e) {
            Trace.logError(LanguageException.class, "Failed to set language exception properties. Cause: " + e.getMessage());
        }
        return languageException;
    }
}

