/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.excp;

import com.streamscape.Trace;
import com.streamscape.omf.SerializerSupportException;
import com.streamscape.omf.serializer.SerializerFactory;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.excp.ApplicationFabricException;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.excp.LanguageException;
import com.streamscape.sdo.excp.SQLQueryException;
import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.excp.SoapFaultException;
import com.streamscape.sdo.excp.SoapRequestException;
import com.streamscape.sdo.excp.TransportException;
import com.streamscape.sdo.excp.ValidationException;
import com.streamscape.sdo.excp.XMLParseException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import java.util.HashSet;
import java.util.Set;

public class ExceptionDatagramFactory
extends IAbstractDatagramFactory {
    private static ExceptionDatagramFactory instance = null;
    private Set<String> systemExceptions = new HashSet<String>();

    protected ExceptionDatagramFactory() {
        super("ExceptionDatagramFactory", "exception", 9969000000302072L);
        Trace.logDebug(this, "Instantiated Exception Datagram factory.");
    }

    @Override
    protected void addDatagramEntries() {
        this.addDatagramEntry(new ApplicationFabricException(), "ApplicationFabricException event object.");
        this.addDatagramEntry(new ClientException(), "ClientException event object.", "exception.cli.Interface");
        this.addDatagramEntry(new DatabaseSQLException(), "DatabaseSQLException event object.", "exception.dbms.SQLStatement");
        this.addDatagramEntry(new FabricEventException(), "FabricEventException event object.", "exception.sef.Event");
        this.addDatagramEntry(new LanguageException(), "LanguageException event object.", "exception.Language");
        this.addDatagramEntry(new SQLQueryException(), "SQLQueryException event object.", "exception.sql.Query");
        this.addDatagramEntry(new SQLQueryParseException(), "SQLQueryParseException event object.", "exception.sql.QueryParse");
        this.addDatagramEntry(new SQLQueryValidationException(), "SQLQueryValidationException event object.", "exception.sql.QueryValidation");
        this.addDatagramEntry(new ServiceFrameworkException(), "ServiceFrameworkException event object.", "exception.service.Framework");
        this.addDatagramEntry(new SoapFaultException(), "SoapFaultException event object.", "exception.ws.SoapFault");
        this.addDatagramEntry(new SoapRequestException(), "SoapRequestException event object.", "exception.ws.SoapRequest");
        this.addDatagramEntry(new TransportException(), "TransportException event object.", "exception.mpi.Transport");
        this.addDatagramEntry(new ValidationException(), "ValidationException event object.", "exception.Validation");
        this.addDatagramEntry(new XMLParseException(), "XMLParseException event object.", "exception.xml.Parsing");
    }

    @Override
    public void initSerializer(SerializerFactory factory, String serializerName) throws SerializerSupportException {
        if (factory instanceof XSerializerFactory) {
            XSerializer serializer = (XSerializer)factory.lookupSerializer(serializerName);
            serializer.getDefaultsProvider().setFieldDefault("eventSource", byte[].class, IAbstractExceptionEvent.class, new byte[0]);
            serializer.getDefaultsProvider().setFieldStringDefault("eventId", String.class, IAbstractExceptionEvent.class, "");
            serializer.getDefaultsProvider().setFieldStringDefault("eventKey", String.class, IAbstractExceptionEvent.class, "");
            serializer.getDefaultsProvider().setFieldStringDefault("eventGroupId", String.class, IAbstractExceptionEvent.class, "");
            serializer.getDefaultsProvider().setFieldDefault("correlationId", byte[].class, IAbstractExceptionEvent.class, new byte[0]);
            serializer.getDefaultsProvider().setFieldStringDefault("eventReplyTo", String.class, IAbstractExceptionEvent.class, "");
            serializer.mapFieldToElement("errorMessage", Throwable.class, "detailMessage");
        }
    }

    @Override
    protected void initSerializers() throws SerializerSupportException {
        this.initSerializer(context.getXSerializerFactory(), "RuntimeCache$Serializer");
    }

    public static ExceptionDatagramFactory getInstance() {
        if (instance == null) {
            instance = new ExceptionDatagramFactory();
        }
        return instance;
    }

    @Override
    public ExceptionEventDatagram createEvent(Prototype prototype) throws DatagramFactoryException {
        return (ExceptionEventDatagram)super.createEvent(prototype);
    }

    @Override
    public ExceptionEventDatagram createEvent(String eventId) throws DatagramFactoryException {
        return (ExceptionEventDatagram)super.createEvent(eventId);
    }

    @Override
    public ExceptionEventDatagram cloneEvent(ImmutableEventDatagram event) throws DatagramFactoryException {
        return (ExceptionEventDatagram)super.cloneEvent(event);
    }

    public ExceptionEventDatagram createEvent(String eventId, ImmutableEventDatagram sourceEvent) throws DatagramFactoryException {
        ExceptionEventDatagram result = (ExceptionEventDatagram)super.createEvent(eventId);
        result.setEventSink(sourceEvent.getEventSource());
        return result;
    }

    @Override
    public ExceptionEventDatagram newEventInstance(SemanticType type) throws DatagramFactoryException {
        return (ExceptionEventDatagram)super.newEventInstance(type);
    }

    @Override
    public ExceptionEventDatagram newEventInstance(String semanticType) throws DatagramFactoryException {
        return (ExceptionEventDatagram)super.newEventInstance(semanticType);
    }

    @Override
    public ExceptionEventDatagram newEventInstanceFrom(String eventId) throws DatagramFactoryException {
        return (ExceptionEventDatagram)super.newEventInstanceFrom(eventId);
    }

    @Override
    public ExceptionEventDatagram newEventInstanceFrom(ImmutableEventDatagram event) throws DatagramFactoryException {
        return (ExceptionEventDatagram)super.newEventInstanceFrom(event);
    }

    @Override
    protected void checkSemanticType(String model, ImmutableEventDatagram event) throws DatagramFactoryException {
        if (event instanceof ApplicationFabricException) {
            SemanticType type = context.getSemanticTypeCache().lookupSemanticClass(event.getClass());
            if (type == null) {
                type = TypeFactory.createSemanticType(event.getClass().getSimpleName(), event.getClass());
                type.setAncestorType(ApplicationFabricException.class.getSimpleName());
                try {
                    context.getSemanticTypeFactory().addSemanticType(type);
                }
                catch (SemanticTypeFactoryException exception) {
                    throw new DatagramFactoryException(exception.getErrorCode(), (Throwable)exception);
                }
            } else if (!model.equals(type.getTypeName()) && !model.equals(type.getAncestorType())) {
                throw new DatagramFactoryException(5034, "Prototype model '" + model + "' does not match datagram semantic type '" + type.getTypeName() + "'.");
            }
        } else {
            super.checkSemanticType(model, event);
        }
    }

    @Override
    protected void checkPrototypeModel(SemanticType type, ImmutableEventDatagram event) throws DatagramFactoryException {
        if (event instanceof ApplicationFabricException) {
            if (!type.getTypeName().equals(ApplicationFabricException.class.getSimpleName()) && !type.getAncestorType().equals(ApplicationFabricException.class.getSimpleName())) {
                throw new DatagramFactoryException(5035, ErrorMessages.format("Event prototype model '%1$s' is not supported.", type.getTypeName()));
            }
        } else {
            this.checkPrototypeModel(type);
        }
    }

    @Override
    protected void loadRegisteredPrototypes() throws DatagramFactoryException, SDOException {
        super.loadRegisteredPrototypes();
    }

    @Override
    protected void addSupportedTypes() throws DatagramFactoryException {
        super.addSupportedTypes();
    }
}

