/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sef.utils.Utils;

public final class XMPPEvent
extends AbstractMutableEvent
implements EventDatagram {
    public static final String MESSAGE_EVENT_ID = "event.xmpp.message";
    public static final String PRESENCE_EVENT_ID = "event.xmpp.presence";
    public static final String IQ_EVENT_ID = "event.xmpp.iq";
    public static final String TYPE_GET = "get";
    public static final String TYPE_SET = "set";
    public static final String TYPE_RESULT = "result";
    public static final String TYPE_ERROR = "error";
    public static final String TYPE_AVAILABLE = "available";
    public static final String TYPE_UNAVAILABLE = "unavailable";
    public static final String TYPE_SUBSCRIBE = "subscribe";
    public static final String TYPE_SUBSCRIBED = "subscribed";
    public static final String TYPE_UNSUBSCRIBE = "unsubscribe";
    public static final String TYPE_UNSUBSCRIBED = "unsubscribed";
    public static final String TYPE_PROBE = "probe";
    private static final String TO_PROPERTY = "to";
    private static final String FROM_PROPERTY = "from";
    private static final String TYPE_PROPERTY = "type";
    private static final String ERROR_PROPERTY = "error";
    private static final String ERROR_CODE_PROPERTY = "errorCode";
    private static final String PRIORITY_PROPERTY = "priority";
    private static final String ID_PROPERTY = "id";
    private static final String SUBJECT_PROPERTY = "subject";
    protected String body;

    protected XMPPEvent() {
    }

    protected XMPPEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public String getTo() {
        return this.getEventStringPropertyOrNull(TO_PROPERTY);
    }

    public void setTo(String to) {
        this.reset(false);
        this.setEventStringPropertyOrNull(TO_PROPERTY, to);
    }

    public String getFrom() {
        return this.getEventStringPropertyOrNull(FROM_PROPERTY);
    }

    public void setFrom(String from) {
        this.setEventStringPropertyOrNull(FROM_PROPERTY, from);
    }

    public String getType() {
        return this.getEventStringPropertyOrNull(TYPE_PROPERTY);
    }

    public void setType(String type) {
        this.setEventStringPropertyOrNull(TYPE_PROPERTY, type);
    }

    public String getError() {
        return this.getEventStringPropertyOrNull("error");
    }

    public void setError(String error) {
        this.setEventStringPropertyOrNull("error", error);
    }

    public int getErrorCode() {
        return this.getEventIntPropertyOrNeg(ERROR_CODE_PROPERTY);
    }

    public void setErrorCode(int errorCode) {
        this.setEventIntPropertyOrNeg(ERROR_CODE_PROPERTY, errorCode);
    }

    public int getPriority() {
        return this.getEventIntPropertyOrNeg(PRIORITY_PROPERTY);
    }

    public void setPriority(int priority) {
        this.setEventIntPropertyOrNeg(PRIORITY_PROPERTY, priority);
    }

    public String getId() {
        return this.getEventStringPropertyOrNull(ID_PROPERTY);
    }

    public void setId(String id) {
        this.setEventStringPropertyOrNull(ID_PROPERTY, id);
    }

    public String getThread() {
        return this.getId();
    }

    public void setThread(String thread) {
        this.setId(thread);
    }

    public String getSubject() {
        return this.getEventStringPropertyOrNull(SUBJECT_PROPERTY);
    }

    public void setSubject(String subject) {
        this.setEventStringPropertyOrNull(SUBJECT_PROPERTY, subject);
    }

    public String getShow() {
        return this.getSubject();
    }

    public void setShow(String show) {
        this.setSubject(show);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getStatus() {
        return this.getBody();
    }

    public void setStatus(String status) {
        this.setBody(status);
    }

    public String getData() {
        return this.getBody();
    }

    public void setData(String data) {
        this.setBody(data);
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return this.getBody();
    }

    protected String getEventStringPropertyOrNull(String name) {
        try {
            String property = this.getEventStringProperty(name);
            return property.isEmpty() ? null : property;
        }
        catch (Exception exc) {
            return null;
        }
    }

    protected void setEventStringPropertyOrNull(String name, String value) {
        try {
            if (value != null) {
                this.setEventStringProperty(name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getEventIntPropertyOrNeg(String name) {
        try {
            return this.getEventIntProperty(name);
        }
        catch (Exception exc) {
            return -1;
        }
    }

    protected void setEventIntPropertyOrNeg(String name, int value) {
        try {
            this.setEventIntProperty(name, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static XMPPEvent createPrototype() {
        try {
            XMPPEvent result = new XMPPEvent();
            result.setEventStringProperty(TO_PROPERTY, "");
            result.setEventStringProperty(FROM_PROPERTY, "");
            result.setEventStringProperty(TYPE_PROPERTY, "");
            result.setEventStringProperty("error", "");
            result.setEventIntProperty(ERROR_CODE_PROPERTY, -1);
            result.setEventIntProperty(PRIORITY_PROPERTY, -1);
            result.setEventStringProperty(ID_PROPERTY, "");
            result.setEventStringProperty(SUBJECT_PROPERTY, "");
            return result;
        }
        catch (Exception exception) {
            throw new RuntimeException("Creation of XMPPEvent prototype failed.", exception);
        }
    }

    @Override
    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException {
        if (!sdrPath.equals("//body")) {
            throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath));
        }
        return String.class;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof XMPPEvent && super.equals(other) && Utils.equalsNullSafe(this.body, ((XMPPEvent)other).body);
    }
}

