/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.Trace;
import com.streamscape.lib.xml.XMLNode;
import com.streamscape.lib.xml.XMLNodeEventListener;
import com.streamscape.lib.xml.XMLNodeEventSource;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.EventAnnotation;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sef.utils.Utils;
import java.util.HashMap;

public final class XMLEvent
extends AbstractMutableEvent
implements EventDatagram {
    protected String xml;
    protected transient String semanticType = null;
    protected transient String semanticClass = null;
    protected transient XSerializer serializer = null;
    private static final String XML_VERSION = "<?xml version=\"1.0\"?>\n";

    protected XMLEvent() {
    }

    protected XMLEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public void setConstraint(SemanticType type) throws SDOException, SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        if (type == null) {
            throw new SDOException("Null Semantic Type specified.");
        }
        if (this.semanticType != null) {
            throw new SDOException("Semantic Constraint already defined. Must be cleared first.");
        }
        this.semanticType = type.getTypeName();
        this.semanticClass = type.getClassName();
    }

    public void clearConstraint() throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        this.semanticType = null;
        this.semanticClass = null;
    }

    public boolean hasConstraint() {
        return this.semanticType != null;
    }

    public void setXML(Object data) throws SecurityViolationException, SDOException, SerializerException {
        this.assertState();
        this.assertWriteAccess();
        if (data == null) {
            throw new SDOException("Object Mediation Error: data element is null.");
        }
        if (this.serializer == null) {
            throw new SDOException("Object Mediation Error: XSerializer is null.");
        }
        if (this.semanticType == null) {
            throw new SDOException("Semantic Constraint Error: Semantic Constraint is undefined.");
        }
        if (!data.getClass().getName().equals(this.semanticClass)) {
            throw new SDOException("Semantic Constraint Violation: Expected '" + this.semanticClass + "', received '" + data.getClass().getName() + "'.");
        }
        this.xml = this.serializer.serialize(this.semanticType, data);
    }

    public void setXML(SemanticType type, Object data) throws SecurityViolationException, SDOException, SerializerException {
        this.clearConstraint();
        this.setConstraint(type);
        this.setXML(data);
    }

    public void setXML(String xml) throws SecurityViolationException, SDOException, SerializerException {
        this.assertState();
        this.assertWriteAccess();
        if (this.hasConstraint()) {
            this.serializer.deserialize(this.semanticType, xml);
        } else {
            try {
                XMLNodeEventSource parser = new XMLNodeEventSource();
                parser.initFromString(xml);
                parser.invoke();
            }
            catch (Exception parseError) {
                throw new SDOException("Incorrect xml specified: " + String.valueOf(parseError));
            }
        }
        this.xml = xml;
    }

    public String getXML() throws SecurityViolationException {
        this.assertReadAccess();
        return this.xml;
    }

    public String getXFragment() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        return this.xml.startsWith(XML_VERSION) ? this.xml.substring(XML_VERSION.length(), this.xml.length()) : this.xml;
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException {
        return this.getXML();
    }

    protected void initSerializer(XSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    protected void doAnnotate() throws SDOException {
        try {
            HashMap<String, EventAnnotation> annotations = this.getAnnotations();
            if (annotations != null) {
                XMLNodeEventSource parser = new XMLNodeEventSource();
                parser.initFromString(this.xml);
                for (EventAnnotation annotation : annotations.values()) {
                    parser.addEventListener(annotation.getSDRPath(), new AnnotationXMLListener(annotation.getPropertyName(), annotation.getSDRPath()));
                }
                parser.invoke();
            }
        }
        catch (Exception parseError) {
            throw new SDOException(parseError);
        }
    }

    @Override
    protected Class getPropertyClass(String sdrPath) {
        return String.class;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof XMLEvent && super.equals(other) && Utils.equalsNullSafe(this.xml, ((XMLEvent)other).xml);
    }

    class AnnotationXMLListener
    implements XMLNodeEventListener {
        private String propertyName;
        private String xmlPath;

        public AnnotationXMLListener(String property, String path) {
            this.propertyName = property;
            this.xmlPath = path;
        }

        @Override
        public void onData(XMLNode data) {
            try {
                String value = data.getXDoc();
                int start = value.indexOf(62) + 1;
                int end = value.lastIndexOf(60);
                if (end < 0) {
                    end = value.length();
                }
                XMLEvent.this.setAnnotatedProperty(this.propertyName, value.substring(start, end));
            }
            catch (SDOException error) {
                Trace.logError(this, "Setting annotated property failed: " + String.valueOf(error));
            }
        }

        @Override
        public String getEventId() {
            return XMLEvent.this.eventId;
        }

        @Override
        public String getXPath() {
            return this.xmlPath;
        }
    }
}

