/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.StreamState;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sef.utils.Utils;

public final class StreamStateEvent
extends AbstractMutableEvent
implements EventDatagram {
    protected StreamState streamState = StreamState.CLOSE;
    protected String stateMessage = null;
    protected long streamPosition = 0L;

    protected StreamStateEvent() {
        this.addAnnotations();
    }

    protected StreamStateEvent(String eventId) throws SDOFormatException {
        super(eventId);
        this.addAnnotations();
    }

    public long getStreamPosition() throws SecurityViolationException {
        this.assertReadAccess();
        return this.streamPosition;
    }

    public void setStreamPosition(long position) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.streamPosition = position;
    }

    public StreamState getStreamState() throws SecurityViolationException {
        this.assertReadAccess();
        return this.streamState;
    }

    public void setStreamState(StreamState streamState) throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        this.streamState = streamState;
    }

    public String getStateMessage() throws SecurityViolationException {
        this.assertReadAccess();
        return this.stateMessage;
    }

    public void setStateMessage(String stateMessage) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.stateMessage = stateMessage;
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return this.stateMessage;
    }

    protected void addAnnotations() {
        try {
            this.addAnnotationSafe("StreamState", "//streamState");
        }
        catch (Exception exception) {
            throw new SDORuntimeException("Adding of 'StreamState' annotation failed.", exception);
        }
    }

    @Override
    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException {
        if (sdrPath.equals("//streamState") || sdrPath.equals("//stateMessage")) {
            return String.class;
        }
        if (sdrPath.equals("//streamPosition")) {
            return Long.class;
        }
        throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath));
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof StreamStateEvent && super.equals(other) && Utils.equalsNullSafe((Object)this.streamState, (Object)((StreamStateEvent)other).streamState) && Utils.equalsNullSafe(this.stateMessage, ((StreamStateEvent)other).stateMessage) && this.streamPosition == ((StreamStateEvent)other).streamPosition;
    }
}

