/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.ChunkEvent;

public final class StreamEvent
extends BytesEvent {
    public static final String CHUNK_SIZE_PROPERTY = "chunkSize";
    public static final String CHUNK_DELAY_PROPERTY = "chunkDelay";
    private transient boolean skipFullEvent = false;

    protected StreamEvent() {
        this.initProperties();
    }

    protected StreamEvent(String eventId) throws SDOFormatException {
        super(eventId);
        this.initProperties();
    }

    protected void initProperties() {
        try {
            this.setEventIntProperty(CHUNK_SIZE_PROPERTY, 0);
            this.setEventLongProperty(CHUNK_DELAY_PROPERTY, 0L);
        }
        catch (Exception exception) {
            throw new SDORuntimeException("Adding properties failed.", exception);
        }
    }

    public String getChunkEventId() {
        return ChunkEvent.getEventId(this.eventId);
    }

    public int getChunkSize() {
        try {
            return this.getEventIntProperty(CHUNK_SIZE_PROPERTY);
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setChunkSize(int chunkSize) {
        try {
            this.setEventIntProperty(CHUNK_SIZE_PROPERTY, chunkSize);
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public long getChunkDelay() {
        try {
            return this.getEventLongProperty(CHUNK_DELAY_PROPERTY);
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setChunkDelay(long chunkDelay) {
        try {
            this.setEventLongProperty(CHUNK_DELAY_PROPERTY, chunkDelay);
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean skipFullEvent() {
        return this.skipFullEvent;
    }

    public void setSkipFullEvent(boolean skipFullEvent) {
        this.skipFullEvent = skipFullEvent;
    }
}

