/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.EventAnnotation;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AbstractRowEvent;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetFactory;
import com.streamscape.sdo.utils.SDOUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RowSetEvent
extends AbstractRowEvent {
    protected RowSet rowSet = null;
    private static final Pattern PATTERN = Pattern.compile("(?://row\\[(\\d+)\\]/(.+))");
    private static final Pattern COLUMN_PATTERN = Pattern.compile("(?:column\\[(\\d+)\\])");
    private static final Pattern OUT_PARAM_PATTERN = Pattern.compile("(?:output\\[([^\\s]+)\\])");

    protected RowSetEvent() {
    }

    protected RowSetEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public RowSet getRowSet() throws SecurityViolationException {
        this.assertReadAccess();
        this.cloneReturnDataSafe();
        return this.rowSet;
    }

    public void init(ResultSet resultSet) throws SecurityViolationException, SQLException {
        this.assertState();
        this.assertWriteAccess();
        this.rowSet = new RowSetFactory().createRowSet(resultSet);
        this.resetDataCounter();
    }

    public void init(RowSet rowSet) throws SecurityViolationException, SQLException {
        this.assertState();
        this.assertWriteAccess();
        this.rowSet = new RowSet(rowSet);
        this.resetDataCounter();
    }

    public void init(RowMetaData descriptor) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        if (this.eventId != null) {
            throw new SecurityViolationException(5023, ErrorMessages.format("Event [%1$s] is already initialized and its signature cannot be changed.", this.eventId));
        }
        this.rowSet = new RowSet(descriptor);
        this.resetDataCounter();
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException {
        return this.getRowSet();
    }

    @Override
    protected void doCloneReturnData() {
        if (this.rowSet != null) {
            this.rowSet = this.rowSet.clone();
        }
    }

    @Override
    protected ColumnDescriptor getColumn(String sdrPath) throws MetaDataException {
        Matcher matcher = PATTERN.matcher(sdrPath);
        if (matcher.matches()) {
            String column = matcher.group(2);
            if ((matcher = COLUMN_PATTERN.matcher(column)).matches()) {
                return this.rowSet.getRowMetaData().getColumnDescriptor(Integer.parseInt(matcher.group(1)));
            }
            return this.rowSet.getRowMetaData().getColumnDescriptor(column);
        }
        Matcher paramMatcher = OUT_PARAM_PATTERN.matcher(sdrPath);
        if (paramMatcher.find()) {
            String column = paramMatcher.group(1);
            Integer columnIndex = -1;
            try {
                columnIndex = Integer.parseInt(column);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (columnIndex == -1) {
                return this.rowSet.getRowMetaData().getOutParameterColumnDescriptor(column);
            }
            return this.rowSet.getRowMetaData().getOutParameterColumnDescriptor(columnIndex);
        }
        return null;
    }

    @Override
    protected void doAnnotate() throws SDOException {
        HashMap<String, EventAnnotation> annotations = this.getAnnotations();
        if (annotations != null) {
            for (EventAnnotation annotation : annotations.values()) {
                Object value = null;
                try {
                    value = this.extractValueFromRowSet(annotation.getSDRPath());
                }
                catch (SQLException exception) {
                    throw new SDOException("Failed to extract values from RowSet. Cause: " + exception.getMessage());
                }
                if (value == null) continue;
                this.setAnnotatedProperty(annotation.getPropertyName(), value);
            }
        }
    }

    protected Object extractValueFromRowSet(String sdrPath) throws SQLException, SDOException {
        Matcher matcher = PATTERN.matcher(sdrPath);
        if (matcher.matches()) {
            Integer rowIndex = Integer.parseInt(matcher.group(1));
            String column = matcher.group(2);
            if ((matcher = COLUMN_PATTERN.matcher(column)).matches()) {
                if (!this.rowSet.absolute(rowIndex - 1)) {
                    throw new SDOException("Failed to extract values from RowSet. Invalid row index " + rowIndex);
                }
                return this.rowSet.getObject(Integer.parseInt(matcher.group(1)));
            }
            if (!this.rowSet.absolute(rowIndex - 1)) {
                throw new SDOException("Failed to extract values from RowSet. Invalid row index " + rowIndex);
            }
            return this.rowSet.getObject(column);
        }
        Matcher paramMatcher = OUT_PARAM_PATTERN.matcher(sdrPath);
        if (paramMatcher.find()) {
            String column = paramMatcher.group(1);
            Integer columnIndex = -1;
            try {
                columnIndex = Integer.parseInt(column);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (columnIndex == -1) {
                return this.rowSet.getOutParameterValue(column);
            }
            return this.rowSet.getOutParameterValue(columnIndex);
        }
        return null;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof RowSetEvent && super.equals(other) && SDOUtils.equals(this.rowSet, ((RowSetEvent)other).rowSet);
    }
}

