/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.EventAnnotation;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AbstractRowEvent;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.utils.SDOUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RowEvent
extends AbstractRowEvent {
    protected Row row = null;
    private static final String ROW = "//row/";
    private static final Pattern COLUMN = Pattern.compile("(?:column\\[(\\d+)\\])");

    protected RowEvent() {
    }

    protected RowEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public Row getRow() throws SecurityViolationException {
        this.assertReadAccess();
        this.cloneReturnDataSafe();
        return this.row;
    }

    public void init(ResultSet resultSet) throws SecurityViolationException, SQLException, MetaDataException, RowException {
        this.assertState();
        this.assertWriteAccess();
        this.row = new Row(resultSet);
        this.resetDataCounter();
    }

    public void init(Row row) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.row = row.clone();
        this.resetDataCounter();
    }

    public void init(RowMetaData descriptor) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        if (this.eventId != null) {
            throw new SecurityViolationException(5023, ErrorMessages.format("Event [%1$s] is already initialized and its signature cannot be changed.", this.eventId));
        }
        this.row = new Row(descriptor);
        this.resetDataCounter();
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException {
        return this.getRow();
    }

    @Override
    protected void doCloneReturnData() {
        if (this.row != null) {
            this.row = this.row.clone();
        }
    }

    @Override
    protected ColumnDescriptor getColumn(String sdrPath) throws MetaDataException {
        if (sdrPath.startsWith(ROW)) {
            String column = sdrPath.substring(ROW.length());
            Matcher matcher = COLUMN.matcher(column);
            if (matcher.matches()) {
                return this.row.getMetaData().getColumnDescriptor(Integer.parseInt(matcher.group(1)));
            }
            return this.row.getMetaData().getColumnDescriptor(column);
        }
        return null;
    }

    @Override
    protected void doAnnotate() throws SDOException {
        HashMap<String, EventAnnotation> annotations = this.getAnnotations();
        if (annotations != null) {
            for (EventAnnotation annotation : annotations.values()) {
                Object value = this.extractValueFromRow(annotation.getSDRPath());
                if (value == null) continue;
                this.setAnnotatedProperty(annotation.getPropertyName(), value);
            }
        }
    }

    protected Object extractValueFromRow(String sdrPath) {
        try {
            String column = sdrPath.substring(ROW.length());
            Matcher matcher = COLUMN.matcher(column);
            if (matcher.matches()) {
                return this.row.getColumn(Integer.parseInt(matcher.group(1)));
            }
            return this.row.getColumn(column);
        }
        catch (SDOException error) {
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof RowEvent && super.equals(other) && SDOUtils.equals(this.row, ((RowEvent)other).row);
    }
}

