/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.EventAnnotation;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AbstractRowEvent;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.utils.SDOUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RowChangeEvent
extends AbstractRowEvent {
    protected Row rowBefore = null;
    protected Row rowAfter = null;
    private static final String ROW_BEFORE = "//rowBefore/";
    private static final String ROW_AFTER = "//rowAfter/";
    private static final Pattern COLUMN = Pattern.compile("(?:column\\[(\\d+)\\])");

    public boolean equals() {
        return this.rowBefore.equals(this.rowAfter);
    }

    public Row getBeforeImage() throws SecurityViolationException {
        this.assertReadAccess();
        this.cloneReturnDataSafe();
        return this.rowBefore;
    }

    public Row getAfterImage() throws SecurityViolationException {
        this.assertReadAccess();
        this.cloneReturnDataSafe();
        return this.rowAfter;
    }

    public List<String> getDeltaElements() {
        return null;
    }

    public Map<String, Object> getDeltas() {
        return null;
    }

    public void setBeforeImage(Row row) throws SDOException, SecurityViolationException {
        if (row == null) {
            throw new SDOException("Before image object is null.");
        }
        this.assertState();
        this.assertWriteAccess();
        this.rowBefore = row;
    }

    public void setAfterImage(Row row) throws SDOException, SecurityViolationException {
        if (row == null) {
            throw new SDOException("After image object is null.");
        }
        this.assertState();
        this.assertWriteAccess();
        this.rowAfter = row;
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException {
        return this.getAfterImage();
    }

    @Override
    protected void doCloneReturnData() {
        if (this.rowBefore != null) {
            this.rowBefore = this.rowBefore.clone();
        }
        if (this.rowAfter != null) {
            this.rowAfter = this.rowAfter.clone();
        }
    }

    @Override
    protected ColumnDescriptor getColumn(String sdrPath) throws MetaDataException {
        if (sdrPath.startsWith(ROW_BEFORE)) {
            return this.getColumn(this.rowBefore, sdrPath.substring(ROW_BEFORE.length()));
        }
        if (sdrPath.startsWith(ROW_AFTER)) {
            return this.getColumn(this.rowAfter, sdrPath.substring(ROW_AFTER.length()));
        }
        return null;
    }

    private ColumnDescriptor getColumn(Row row, String column) throws MetaDataException {
        Matcher matcher = COLUMN.matcher(column);
        if (matcher.matches()) {
            return row.getMetaData().getColumnDescriptor(Integer.parseInt(matcher.group(1)));
        }
        return row.getMetaData().getColumnDescriptor(column);
    }

    @Override
    protected void doAnnotate() throws SDOException {
        HashMap<String, EventAnnotation> annotations = this.getAnnotations();
        if (annotations != null) {
            for (EventAnnotation annotation : annotations.values()) {
                Object value = this.extractValueFromRow(annotation.getSDRPath());
                if (value == null) continue;
                this.setAnnotatedProperty(annotation.getPropertyName(), value);
            }
        }
    }

    protected Object extractValueFromRow(String sdrPath) {
        try {
            if (sdrPath.startsWith(ROW_BEFORE)) {
                return this.extractValueFromRowByColumnId(this.rowBefore, sdrPath.substring(ROW_BEFORE.length()));
            }
            if (sdrPath.startsWith(ROW_AFTER)) {
                return this.extractValueFromRowByColumnId(this.rowAfter, sdrPath.substring(ROW_AFTER.length()));
            }
        }
        catch (SDOException error) {
            return null;
        }
        return null;
    }

    protected Object extractValueFromRowByColumnId(Row row, String columnSpec) throws SDOException {
        Matcher matcher = COLUMN.matcher(columnSpec);
        if (matcher.matches()) {
            return row.getColumn(Integer.parseInt(matcher.group(1)));
        }
        return row.getColumn(columnSpec);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof RowChangeEvent && super.equals(other) && SDOUtils.equals(this.rowBefore, ((RowChangeEvent)other).rowBefore) && SDOUtils.equals(this.rowAfter, ((RowChangeEvent)other).rowAfter);
    }
}

