/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.EventAnnotation;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AbstractRowEvent;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.DataRow;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowArrayException;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.utils.SDOUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RowArrayEvent
extends AbstractRowEvent {
    protected RowArray rowArray = null;
    private static final Pattern PATTERN = Pattern.compile("(?://row\\[([^\\[]+)\\]/(.+))");
    private static final Pattern COLUMN_PATTERN = Pattern.compile("(?:column\\[(\\d+)\\])");

    protected RowArrayEvent() {
    }

    protected RowArrayEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public RowArray getRowArray() throws SecurityViolationException {
        this.assertReadAccess();
        this.cloneReturnDataSafe();
        return this.rowArray;
    }

    public void init(RowArray rowArray) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        if (this.rowArray == null) {
            this.rowArray = rowArray;
            this.resetDataCounter();
        }
    }

    public void init(RowMetaData metaData) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        if (this.eventId != null) {
            throw new SecurityViolationException(5023, ErrorMessages.format("Event [%1$s] is already initialized and its signature cannot be changed.", this.eventId));
        }
        if (this.rowArray == null) {
            this.rowArray = new RowArray(metaData);
            this.resetDataCounter();
        }
    }

    public void init(ResultSet resultSet) throws SecurityViolationException, SQLException, MetaDataException {
        this.assertState();
        this.assertWriteAccess();
        if (this.rowArray == null) {
            this.rowArray = new RowArray();
            this.rowArray.init(resultSet);
            this.resetDataCounter();
        }
    }

    public RowMetaData getMetaData() throws SecurityViolationException {
        this.assertReadAccess();
        this.cloneReturnDataSafe();
        return this.rowArray != null ? this.rowArray.getMetaData() : null;
    }

    public int getCapacity() throws RowArrayException, SecurityViolationException {
        this.assertReadAccess();
        return this.rowArray != null ? this.rowArray.getCapacity() : 0;
    }

    public void setMRUEnabled(boolean cache) throws SecurityViolationException {
        this.assertWriteAccess();
        if (this.rowArray != null) {
            this.cloneDataSafe();
            this.rowArray.setMRUEnabled(cache);
        }
    }

    public boolean isMRUEnabled() throws SecurityViolationException {
        this.assertReadAccess();
        return this.rowArray != null && this.rowArray.isMRUEnabled();
    }

    public boolean containsRow(DataRow row) throws SecurityViolationException {
        this.assertReadAccess();
        return this.rowArray != null && this.rowArray.containsRow(row);
    }

    public DataRow newRow() throws MetaDataException, RowException, SecurityViolationException {
        this.assertReadAccess();
        return this.rowArray != null ? this.rowArray.newRow() : null;
    }

    public void addRow(DataRow row) throws RowArrayException, RowException, SecurityViolationException {
        this.assertWriteAccess();
        if (this.rowArray != null) {
            this.cloneDataSafe();
            this.rowArray.addRow(row);
        }
    }

    public boolean existsKey(Object key) throws RowArrayException, SecurityViolationException {
        this.assertReadAccess();
        return this.rowArray != null && this.rowArray.existsKey(key);
    }

    public void removeRowByKey(Object key) throws RowArrayException, SecurityViolationException {
        this.assertWriteAccess();
        if (this.rowArray != null) {
            this.cloneDataSafe();
            this.rowArray.removeRowByKey(key);
        }
    }

    public void removeRow() throws SecurityViolationException {
        this.assertWriteAccess();
        if (this.rowArray != null) {
            this.cloneDataSafe();
            this.rowArray.removeRow();
        }
    }

    public DataRow getRowByKey(Object key) throws SDOException, SecurityViolationException {
        this.assertReadAccess();
        this.cloneReturnData();
        return this.rowArray != null ? this.rowArray.getRowByKey(key) : null;
    }

    public String getIndexColumnName() throws RowArrayException, SecurityViolationException {
        this.assertReadAccess();
        try {
            return this.rowArray != null ? this.rowArray.getIndexColumnName() : null;
        }
        catch (MetaDataException error) {
            throw new RowArrayException(error);
        }
    }

    public boolean hasKeyIndex() throws RowArrayException, SecurityViolationException {
        this.assertReadAccess();
        return this.rowArray != null && this.rowArray.hasKeyIndex();
    }

    public Iterator<DataRow> iteratorByEntry() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        this.cloneReturnData();
        return this.rowArray != null ? this.rowArray.iteratorByEntry() : null;
    }

    public Iterator<DataRow> iteratorByKey() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        this.cloneReturnData();
        return this.rowArray != null ? this.rowArray.iteratorByKey() : null;
    }

    public int size() throws SecurityViolationException {
        this.assertReadAccess();
        return this.rowArray != null ? Integer.valueOf(this.rowArray.size()) : null;
    }

    public void clear() throws SecurityViolationException {
        this.assertWriteAccess();
        if (this.rowArray != null) {
            this.cloneDataSafe();
            this.rowArray.clear();
        }
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException {
        return this.getRowArray();
    }

    @Override
    protected void doCloneReturnData() {
        if (this.rowArray != null) {
            this.rowArray = this.rowArray.clone();
        }
    }

    @Override
    protected ColumnDescriptor getColumn(String sdrPath) throws MetaDataException {
        Matcher matcher = PATTERN.matcher(sdrPath);
        if (matcher.matches()) {
            String column = matcher.group(2);
            if ((matcher = COLUMN_PATTERN.matcher(column)).matches()) {
                return this.rowArray.getMetaData().getColumnDescriptor(Integer.parseInt(matcher.group(1)));
            }
            return this.rowArray.getMetaData().getColumnDescriptor(column);
        }
        return null;
    }

    @Override
    protected void doAnnotate() throws SDOException {
        HashMap<String, EventAnnotation> annotations = this.getAnnotations();
        if (annotations != null) {
            for (EventAnnotation annotation : annotations.values()) {
                Object value = this.extractValueFromRowSet(annotation.getSDRPath());
                if (value == null) continue;
                this.setAnnotatedProperty(annotation.getPropertyName(), value);
            }
        }
    }

    protected Object extractValueFromRowSet(String sdrPath) {
        try {
            Matcher matcher = PATTERN.matcher(sdrPath);
            if (matcher.matches()) {
                String rowIndex = matcher.group(1);
                String column = matcher.group(2);
                matcher = COLUMN_PATTERN.matcher(column);
                int[] keyColumnIndices = this.rowArray.getMetaData().getKeyColumnsIndices();
                if (keyColumnIndices == null || keyColumnIndices.length != 1) {
                    return Object.class;
                }
                String keyColumnName = this.rowArray.getMetaData().getColumnName(keyColumnIndices[0]);
                if (keyColumnName == null) {
                    return null;
                }
                ColumnDescriptor desc = this.rowArray.getMetaData().getColumnDescriptor(keyColumnName);
                if (matcher.matches()) {
                    DataRow row = this.rowArray.getRowByKey(this.translateKeyIntoRealType(rowIndex, desc.getTypeClass()));
                    return row.getColumn(Integer.parseInt(matcher.group(1)));
                }
                DataRow row = this.rowArray.getRowByKey(this.translateKeyIntoRealType(rowIndex, desc.getTypeClass()));
                int columnIndex = this.rowArray.getMetaData().findColumn(column);
                return row.getColumn(columnIndex);
            }
        }
        catch (MetaDataException error) {
            return null;
        }
        catch (RowException error) {
            return null;
        }
        return null;
    }

    protected Object translateKeyIntoRealType(String keyValue, Class clazz) {
        if (clazz.equals(String.class)) {
            return keyValue;
        }
        if (clazz.equals(Byte.class)) {
            return Byte.parseByte(keyValue);
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.parseBoolean(keyValue);
        }
        if (clazz.equals(Short.class)) {
            return Short.parseShort(keyValue);
        }
        if (clazz.equals(Integer.class)) {
            return Integer.parseInt(keyValue);
        }
        if (clazz.equals(Long.class)) {
            return Long.parseLong(keyValue);
        }
        if (clazz.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(keyValue));
        }
        if (clazz.equals(Double.class)) {
            return Double.parseDouble(keyValue);
        }
        if (clazz.equals(BigDecimal.class)) {
            return new BigDecimal(keyValue);
        }
        return null;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof RowArrayEvent && super.equals(other) && SDOUtils.equals(this.rowArray, ((RowArrayEvent)other).rowArray);
    }
}

