/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.Trace;
import com.streamscape.omf.SerializerSupportException;
import com.streamscape.omf.serializer.SerializerFactory;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.IAbstractEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.utils.SDOUtils;

public class OpaqueDatagramFactory
extends IAbstractDatagramFactory {
    private static OpaqueDatagramFactory instance = null;

    protected OpaqueDatagramFactory() {
        super("OpaqueDatagramFactory", "opaque");
        Trace.logDebug(this, "Instantiated Opaque Datagram factory.");
    }

    @Override
    protected void addDatagramEntries() {
        this.addDatagramEntry(new OpaqueEvent(), "Opaque data event object.");
    }

    @Override
    public void initSerializer(SerializerFactory factory, String serializerName) throws SerializerSupportException {
        if (factory instanceof XSerializerFactory) {
            XSerializer xserializer = (XSerializer)factory.lookupSerializer(serializerName);
            xserializer.getDefaultsProvider().setFieldDefault("eventSource", byte[].class, IAbstractEvent.class, new byte[0]);
            xserializer.getDefaultsProvider().setFieldStringDefault("eventId", String.class, IAbstractEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("eventKey", String.class, IAbstractEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("eventGroupId", String.class, IAbstractEvent.class, "");
        }
    }

    public static OpaqueDatagramFactory getInstance() {
        if (instance == null) {
            instance = new OpaqueDatagramFactory();
        }
        return instance;
    }

    @Override
    public OpaqueDatagram createEvent(Prototype prototype) throws DatagramFactoryException {
        return (OpaqueDatagram)super.createEvent(prototype);
    }

    @Override
    public OpaqueDatagram createEvent(String eventId) throws DatagramFactoryException {
        return (OpaqueDatagram)super.createEvent(eventId);
    }

    @Override
    public OpaqueDatagram cloneEvent(ImmutableEventDatagram event) throws DatagramFactoryException {
        return (OpaqueDatagram)super.cloneEvent(event);
    }

    @Override
    public OpaqueDatagram newEventInstance(SemanticType type) throws DatagramFactoryException {
        return (OpaqueDatagram)super.newEventInstance(type);
    }

    @Override
    public OpaqueDatagram newEventInstance(String semanticType) throws DatagramFactoryException {
        return (OpaqueDatagram)super.newEventInstance(semanticType);
    }

    @Override
    public OpaqueDatagram newEventInstanceFrom(String eventId) throws DatagramFactoryException {
        return (OpaqueDatagram)super.newEventInstanceFrom(eventId);
    }

    @Override
    public OpaqueDatagram newEventInstanceFrom(ImmutableEventDatagram event) throws DatagramFactoryException {
        return (OpaqueDatagram)super.newEventInstanceFrom(event);
    }

    @Override
    protected void loadRegisteredPrototypes() throws DatagramFactoryException, SDOException {
        super.loadRegisteredPrototypes();
    }

    @Override
    protected void addSupportedTypes() throws DatagramFactoryException {
        super.addSupportedTypes();
    }

    @Override
    protected void resetData(ImmutableEventDatagram event) {
        if (event instanceof OpaqueEvent) {
            ((OpaqueEvent)event).data = null;
        }
    }

    @Override
    protected void resetData(ImmutableEventDatagram event, SemanticType dataType) throws Exception {
        if (event instanceof OpaqueEvent) {
            ((OpaqueEvent)event).setData(SDOUtils.createDataObject(dataType));
        }
    }
}

