/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sef.utils.Utils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class MapEvent
extends AbstractMutableEvent
implements EventDatagram {
    protected HashMap<String, Object> map = new HashMap();
    protected transient Map<String, BiConsumer<MapEvent, String>> specialAnnotations;
    private static final char HASH_SIGN = '#';
    private static final char AT_SIGN = '@';
    private static final BiConsumer<MapEvent, String> ADD_TAGS = (event, str) -> event.parseString((String)str, 35);
    private static final BiConsumer<MapEvent, String> ADD_LOCATORS = (event, str) -> event.parseString((String)str, 64);
    private static final BiConsumer<MapEvent, String> ADD_ALL = (event, str) -> event.parseString((String)str, -1);

    protected MapEvent() {
    }

    protected MapEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public void setMap(Map<String, Object> map) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.cloneDataSafe();
        this.map.clear();
        this.map.putAll(map);
    }

    public HashMap<String, Object> getMap() throws SecurityViolationException {
        this.assertReadAccess();
        return (HashMap)this.map.clone();
    }

    public boolean getBoolean(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        return EventPropertyValidator.checkBooleanValue(value);
    }

    public byte getByte(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        return EventPropertyValidator.checkByteValue(value);
    }

    public short getShort(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        return EventPropertyValidator.checkShortValue(value);
    }

    public char getChar(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new SDOException("Property is not a valid Character.");
    }

    public int getInt(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        return EventPropertyValidator.checkIntValue(value);
    }

    public long getLong(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        return EventPropertyValidator.checkLongValue(value);
    }

    public float getFloat(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        return EventPropertyValidator.checkFloatValue(value);
    }

    public double getDouble(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        return EventPropertyValidator.checkDoubleValue(value);
    }

    public BigDecimal getBigDecimal(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        return EventPropertyValidator.checkBigDecimalValue(value);
    }

    public String getString(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        if (value == null) {
            return null;
        }
        return EventPropertyValidator.checkStringValue(value);
    }

    public byte[] getBytes(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])((byte[])value).clone();
        }
        throw new SDOException("Property is not a valid byte_array.");
    }

    public Date getDate(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new SDOException("Property is not a valid Date.");
    }

    public Object getObject(String name) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        Object value = this.map.get(name);
        return value instanceof byte[] ? ((byte[])value).clone() : value;
    }

    public Object get(String name) throws SecurityViolationException, SDOException {
        return this.getObject(name);
    }

    public Set<String> getMapNames() throws SecurityViolationException {
        this.assertReadAccess();
        return new HashSet<String>(this.map.keySet());
    }

    public void setBoolean(String name, boolean value) throws SecurityViolationException {
        this.doSetObject(name, value);
    }

    public void setByte(String name, byte value) throws SecurityViolationException {
        this.doSetObject(name, value);
    }

    public void setShort(String name, short value) throws SecurityViolationException {
        this.doSetObject(name, value);
    }

    public void setChar(String name, char value) throws SecurityViolationException {
        this.doSetObject(name, Character.valueOf(value));
    }

    public void setInt(String name, int value) throws SecurityViolationException {
        this.doSetObject(name, value);
    }

    public void setLong(String name, long value) throws SecurityViolationException {
        this.doSetObject(name, value);
    }

    public void setFloat(String name, float value) throws SecurityViolationException {
        this.doSetObject(name, Float.valueOf(value));
    }

    public void setDouble(String name, double value) throws SecurityViolationException {
        this.doSetObject(name, value);
    }

    public void setBigDecimal(String name, BigDecimal value) throws SecurityViolationException {
        this.doSetObject(name, value);
    }

    public void setString(String name, String value) throws SecurityViolationException {
        this.doSetObject(name, value);
    }

    public void setDate(String name, Date value) throws SecurityViolationException {
        this.doSetObject(name, value);
    }

    public void setBytes(String name, byte[] value) throws SecurityViolationException {
        this.doSetObject(name, value.clone());
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws SecurityViolationException {
        byte[] copy = new byte[length];
        System.arraycopy(value, offset, copy, 0, length);
        this.doSetObject(name, copy);
    }

    protected synchronized void doSetObject(String name, Object value) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.putValue(name, value);
    }

    private void putValue(String name, Object value) {
        this.cloneDataSafe();
        this.map.put(name, value);
    }

    public void setObject(String name, Object value) throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        if (value instanceof Boolean) {
            this.setBoolean(name, (Boolean)value);
        } else if (value instanceof Character) {
            this.setChar(name, ((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.setByte(name, (Byte)value);
        } else if (value instanceof Short) {
            this.setShort(name, (Short)value);
        } else if (value instanceof Integer) {
            this.setInt(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLong(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloat(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(name, (Double)value);
        } else if (value instanceof BigDecimal) {
            this.setBigDecimal(name, (BigDecimal)value);
        } else if (value instanceof String) {
            this.setString(name, (String)value);
        } else if (value instanceof Date) {
            this.setDate(name, (Date)value);
        } else if (value instanceof byte[]) {
            this.setBytes(name, (byte[])value);
        } else {
            throw new SDOException("Invalid data type '" + value.getClass().getName() + "' for event [" + this.eventId + "].");
        }
    }

    public void set(String name, Object value) throws SecurityViolationException, SDOException {
        this.setObject(name, value);
    }

    public boolean itemExists(String name) throws SecurityViolationException {
        this.assertReadAccess();
        return this.map.containsKey(name);
    }

    public void clearData() throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.map = new HashMap();
    }

    public void addTag(String tag) throws SecurityViolationException, SDOException {
        if (tag.length() < 2 || !tag.startsWith("#")) {
            throw new SDOFormatException("Invalid hashtag format.");
        }
        this.setString(tag.substring(1), "tag");
    }

    public void addTagsAll(String str) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.parseString(str, 35);
    }

    public void addTagsAllFrom(String propertyName) throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        this.addSpecialAnnotation(propertyName, ADD_TAGS);
    }

    public void addLocator(String locator) throws SecurityViolationException, SDOException {
        if (locator.length() < 2 || !locator.startsWith("@")) {
            throw new SDOFormatException("Invalid locator format.");
        }
        this.setString(locator.substring(1), "locator");
    }

    public void addLocatorsAll(String str) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.parseString(str, 64);
    }

    public void addLocatorsAllFrom(String propertyName) throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        this.addSpecialAnnotation(propertyName, ADD_LOCATORS);
    }

    public void addTagsAndLocatorsAll(String str) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.parseString(str, -1);
    }

    public void addTagsAndLocatorsAllFrom(String propertyName) throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        this.addSpecialAnnotation(propertyName, ADD_ALL);
    }

    private static String getValue(char delimiter) {
        return delimiter == '#' ? "tag" : "locator";
    }

    private static boolean isDelimiter(char c) {
        return c == '#' || c == '@';
    }

    private static boolean isEndOfValue(char c) {
        return Character.isWhitespace(c) || MapEvent.isDelimiter(c);
    }

    private void parseString(String str, int delimiter) {
        int index = 0;
        while (index < str.length()) {
            while (index < str.length() && !MapEvent.isDelimiter(str.charAt(index))) {
                ++index;
            }
            if (index >= str.length()) continue;
            while (index < str.length() && MapEvent.isDelimiter(str.charAt(index))) {
                ++index;
            }
            if (index >= str.length()) continue;
            char currentDelimiter = str.charAt(index - 1);
            int iBegin = index;
            while (index < str.length() && !MapEvent.isEndOfValue(str.charAt(index))) {
                ++index;
            }
            if (index <= iBegin || delimiter != -1 && currentDelimiter != delimiter) continue;
            this.putValue(str.substring(iBegin, index), MapEvent.getValue(currentDelimiter));
        }
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return this.map;
    }

    @Override
    protected void doCloneReturnData() {
        if (this.map != null) {
            this.map = (HashMap)this.map.clone();
        }
    }

    @Override
    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException, TypeAnalyzerException {
        super.getPropertyClass(sdrPath);
        return String.class;
    }

    @Override
    protected void setAnnotatedProperty(String name, Object value) throws SDOException {
        super.setAnnotatedProperty(name, value != null ? value.toString() : value);
    }

    @Override
    protected void doAnnotate() throws SDOException {
        super.doAnnotate();
        if (this.specialAnnotations != null) {
            for (Map.Entry<String, BiConsumer<MapEvent, String>> entry : this.specialAnnotations.entrySet()) {
                entry.getValue().accept(this, this.getEventStringProperty(entry.getKey()));
            }
        }
    }

    private synchronized void addSpecialAnnotation(String propertyName, BiConsumer<MapEvent, String> value) throws SDOException {
        BiConsumer<MapEvent, String> oldValue;
        this.checkPropertyName(propertyName);
        if (this.eventProperties == null || !this.eventProperties.containsKey(propertyName)) {
            throw new SDOPropertyException("Property '" + propertyName + "' does not exist" + this.inEventInfo());
        }
        if (this.getEventPropertyType(propertyName) != PropertyType.String) {
            throw new SDOPropertyException("Property '" + propertyName + "' is not String property " + this.inEventInfo());
        }
        if (this.specialAnnotations == null) {
            this.specialAnnotations = new HashMap<String, BiConsumer<MapEvent, String>>();
        }
        if ((oldValue = this.specialAnnotations.get(propertyName)) == null) {
            this.specialAnnotations.put(propertyName, value);
        } else if (oldValue != value) {
            this.specialAnnotations.put(propertyName, ADD_ALL);
        }
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof MapEvent && super.equals(other) && Utils.equalsNullSafe(this.map, ((MapEvent)other).map);
    }
}

