/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.EventAnnotation;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sef.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MailEvent
extends AbstractMutableEvent
implements EventDatagram {
    protected String subject;
    protected List<String> from;
    protected List<String> to;
    protected List<String> cc;
    protected List<String> bcc;
    protected String body;
    protected String contentType;
    protected ArrayList<MailAttachment> attachments;
    protected Date sentDate = null;
    protected Date receivedDate = null;
    protected String lastMessage;
    protected String fromAddress;
    protected String fromName;
    protected String signature;
    protected List<String> toAddresses;
    private static final Pattern FROM_PATTERN = Pattern.compile("(?://from\\[(\\d+)\\])");
    private static final Pattern TO_PATTERN = Pattern.compile("(?://to\\[(\\d+)\\])");
    private static final Pattern CC_PATTERN = Pattern.compile("(?://cc\\[(\\d+)\\])");

    protected MailEvent() {
    }

    protected MailEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public void setBody(String body) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.body = body;
    }

    public String getBody() throws SecurityViolationException {
        this.assertReadAccess();
        return this.body;
    }

    public void setContentType(String contentType) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.contentType = contentType;
    }

    public String getContentType() throws SecurityViolationException {
        this.assertReadAccess();
        return this.contentType;
    }

    public void setSubject(String subject) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.subject = subject;
    }

    public String getSubject() throws SecurityViolationException {
        this.assertReadAccess();
        return this.subject;
    }

    public void setFrom(List<String> from) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.from = from != null ? new ArrayList(from) : from;
    }

    public List<String> getFrom() throws SecurityViolationException {
        this.assertReadAccess();
        return this.from != null ? new ArrayList<String>(this.from) : null;
    }

    public void setFromAddress(String fromAddress) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.fromAddress = fromAddress;
    }

    public void setFromName(String fromName) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.fromName = fromName;
    }

    public String getFromName() throws SecurityViolationException {
        this.assertReadAccess();
        return this.fromName;
    }

    public void setSignature(String signature) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.signature = signature;
    }

    public String getSignature() throws SecurityViolationException {
        this.assertReadAccess();
        return this.signature;
    }

    public String getFromAddress() throws SecurityViolationException {
        this.assertReadAccess();
        return this.fromAddress;
    }

    public void setTo(List<String> to) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.to = to != null ? new ArrayList(to) : to;
    }

    public List<String> getTo() throws SecurityViolationException {
        this.assertReadAccess();
        return this.to != null ? new ArrayList<String>(this.to) : null;
    }

    public void setToAddresses(List<String> toAddresses) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.toAddresses = toAddresses != null ? new ArrayList(toAddresses) : toAddresses;
    }

    public List<String> getToAddresses() throws SecurityViolationException {
        this.assertReadAccess();
        return this.toAddresses != null ? new ArrayList<String>(this.toAddresses) : null;
    }

    public void setCc(List<String> ccArg) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.cc = ccArg != null ? new ArrayList<String>(ccArg) : null;
    }

    public List<String> getCc() throws SecurityViolationException {
        this.assertReadAccess();
        return this.cc != null ? new ArrayList<String>(this.cc) : null;
    }

    public void setBcc(List<String> bccArg) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.bcc = bccArg != null ? new ArrayList<String>(bccArg) : null;
    }

    public List<String> getBcc() throws SecurityViolationException {
        this.assertReadAccess();
        return this.bcc != null ? new ArrayList<String>(this.bcc) : null;
    }

    public void setSentDate(Date sentDate) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.sentDate = sentDate;
    }

    public Date getSentDate() throws SecurityViolationException {
        this.assertReadAccess();
        return this.sentDate;
    }

    public void setReceivedDate(Date receivedDate) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.receivedDate = receivedDate;
    }

    public Date getReceivedDate() throws SecurityViolationException {
        this.assertReadAccess();
        return this.receivedDate;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(String lastMessage) {
        this.lastMessage = lastMessage;
    }

    public void addAttachment(String name, byte[] data) throws SecurityViolationException {
        this.addAttachment(name, data, null);
    }

    public void addAttachment(String name, byte[] data, String mimeType) throws SecurityViolationException {
        this.addAttachment(name, data, mimeType, null);
    }

    public void addAttachment(String name, byte[] data, String mimeType, String contentId) throws SecurityViolationException {
        this.addAttachment(new MailAttachment(name, data, mimeType, contentId));
    }

    public synchronized void addAttachment(MailAttachment attachment) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        } else {
            this.cloneDataSafe();
        }
        this.attachments.add(attachment);
    }

    public void attachFile(String filePath, String mimeType, String contentId) throws SecurityViolationException, IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IOException("File '" + filePath + "' does not exist.");
        }
        byte[] data = new byte[(int)file.length()];
        try (FileInputStream inputStream = new FileInputStream(file);){
            inputStream.read(data);
        }
        this.addAttachment(file.getName(), data, mimeType, contentId);
    }

    public int getAttachmentsCount() throws SecurityViolationException {
        this.assertReadAccess();
        return this.attachments != null ? this.attachments.size() : 0;
    }

    public MailAttachment getAttachment(int index) throws SecurityViolationException {
        this.assertReadAccess();
        if (this.attachments == null) {
            return null;
        }
        if (index < 0 || index >= this.attachments.size()) {
            return null;
        }
        this.cloneReturnDataSafe();
        return this.attachments.get(index);
    }

    public String getAttachmentName(int index) throws SecurityViolationException {
        MailAttachment attachment = this.getAttachment(index);
        return attachment != null ? attachment.getName() : null;
    }

    public byte[] getAttachmentData(int index) throws SecurityViolationException {
        MailAttachment attachment = this.getAttachment(index);
        return attachment != null ? attachment.getData() : null;
    }

    public String getAttachmentMimeType(int index) throws SecurityViolationException {
        MailAttachment attachment = this.getAttachment(index);
        return attachment != null ? attachment.getMimeType() : null;
    }

    public String getAttachmentContentId(int index) throws SecurityViolationException {
        MailAttachment attachment = this.getAttachment(index);
        return attachment != null ? attachment.getContentId() : null;
    }

    @Override
    protected void doCloneReturnData() {
        if (this.attachments != null) {
            ArrayList<MailAttachment> attachmentsClone = new ArrayList<MailAttachment>(this.attachments.size());
            for (MailAttachment attachment : this.attachments) {
                attachmentsClone.add(attachment.clone());
            }
            this.attachments = attachmentsClone;
        }
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return this.getBody();
    }

    @Override
    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException {
        if (sdrPath.equals("//body") || sdrPath.equals("//subject") || sdrPath.startsWith("//to[") || sdrPath.startsWith("//cc[") || sdrPath.startsWith("//from")) {
            return String.class;
        }
        throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath));
    }

    @Override
    protected void doAnnotate() throws SDOException {
        HashMap<String, EventAnnotation> annotations = this.getAnnotations();
        if (annotations != null) {
            for (EventAnnotation annotation : annotations.values()) {
                Integer index;
                Matcher matcher;
                if (annotation.getSDRPath().equals("//body")) {
                    this.setAnnotatedProperty(annotation.getPropertyName(), this.body);
                    continue;
                }
                if (annotation.getSDRPath().equals("//subject")) {
                    this.setAnnotatedProperty(annotation.getPropertyName(), this.subject);
                    continue;
                }
                if (annotation.getSDRPath().equals("//from")) {
                    this.setAnnotatedProperty(annotation.getPropertyName(), this.fromAddress);
                    continue;
                }
                if (this.from != null && (matcher = FROM_PATTERN.matcher(annotation.getSDRPath())).find()) {
                    index = Integer.valueOf(matcher.group(1));
                    this.setAnnotatedProperty(annotation.getPropertyName(), this.from.get(index));
                }
                if (this.to != null && (matcher = TO_PATTERN.matcher(annotation.getSDRPath())).find()) {
                    index = Integer.valueOf(matcher.group(1));
                    this.setAnnotatedProperty(annotation.getPropertyName(), this.to.get(index));
                }
                if (this.cc == null || !(matcher = CC_PATTERN.matcher(annotation.getSDRPath())).find()) continue;
                index = Integer.valueOf(matcher.group(1));
                this.setAnnotatedProperty(annotation.getPropertyName(), this.cc.get(index));
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof MailEvent && super.equals(other) && Utils.equalsNullSafe(this.subject, ((MailEvent)other).subject) && Utils.equalsNullSafe(this.to, ((MailEvent)other).to) && Utils.equalsNullSafe(this.cc, ((MailEvent)other).cc) && Utils.equalsNullSafe(this.body, ((MailEvent)other).body) && Utils.equalsNullSafe(this.contentType, ((MailEvent)other).contentType) && this.equalsAttachments(((MailEvent)other).attachments);
    }

    protected boolean equalsAttachments(ArrayList<MailAttachment> otherAttachments) {
        if (this.attachments == otherAttachments) {
            return true;
        }
        if (this.attachments != null && otherAttachments != null && this.attachments.size() == otherAttachments.size()) {
            boolean equals = true;
            for (int i = 0; i < this.attachments.size() && (equals = Utils.equalsNullSafe(this.attachments.get(i), otherAttachments.get(i))); ++i) {
            }
            return equals;
        }
        return false;
    }

    public static class MailAttachment
    extends CloneableDataObject {
        private String name;
        private byte[] data;
        private String mimeType = null;
        private String contentId = null;

        public MailAttachment(String name, byte[] data) {
            this.name = name;
            this.data = data;
            this.mimeType = null;
            this.contentId = null;
        }

        public MailAttachment(String name, byte[] data, String mimeType) {
            this.name = name;
            this.data = data;
            this.mimeType = mimeType;
            this.contentId = null;
        }

        public MailAttachment(String name, byte[] data, String mimeType, String contentId) {
            this.name = name;
            this.data = data;
            this.mimeType = mimeType;
            this.contentId = contentId;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getContentId() {
            return this.contentId;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof MailAttachment && Utils.equalsNullSafe(this.name, ((MailAttachment)other).name) && Utils.equalsNullSafe(this.mimeType, ((MailAttachment)other).mimeType) && Arrays.equals(this.data, ((MailAttachment)other).data);
        }

        @Override
        public MailAttachment clone() {
            MailAttachment result = (MailAttachment)super.clone();
            result.data = this.data != null ? (byte[])this.data.clone() : null;
            return result;
        }
    }
}

