/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.EventAnnotation;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sef.utils.Utils;
import java.sql.Timestamp;
import java.util.HashMap;

public class LogEvent
extends AbstractMutableEvent
implements EventDatagram {
    protected long logTimestampMillis;
    protected String logMessage;

    protected LogEvent() {
    }

    protected LogEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public void setLogTimestamp(Timestamp logTimestamp) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.logTimestampMillis = logTimestamp.getTime();
    }

    public Timestamp getLogTimestamp() throws SecurityViolationException {
        this.assertReadAccess();
        return new Timestamp(this.logTimestampMillis);
    }

    public void setLogTimestampMillis(long logTimestampMillis) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.logTimestampMillis = logTimestampMillis;
    }

    public long getLogTimestampMillis() throws SecurityViolationException {
        this.assertReadAccess();
        return this.logTimestampMillis;
    }

    public void setLogMessage(String logMessage) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.logMessage = logMessage;
    }

    public String getLogMessage() throws SecurityViolationException {
        this.assertReadAccess();
        return this.logMessage;
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return null;
    }

    @Override
    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException {
        if (sdrPath.equals("//logTimestamp")) {
            return Timestamp.class;
        }
        if (sdrPath.equals("//logTimestampMillis")) {
            return String.class;
        }
        if (sdrPath.equals("//logMessage")) {
            return String.class;
        }
        throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath));
    }

    @Override
    protected void doAnnotate() throws SDOException {
        HashMap<String, EventAnnotation> annotations = this.getAnnotations();
        if (annotations != null) {
            for (EventAnnotation annotation : annotations.values()) {
                if (annotation.getSDRPath().equals("//logTimestampMillis")) {
                    this.setAnnotatedProperty(annotation.getPropertyName(), this.logTimestampMillis);
                    continue;
                }
                if (!annotation.getSDRPath().equals("//logMessage")) continue;
                this.setAnnotatedProperty(annotation.getPropertyName(), this.logMessage);
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof LogEvent && super.equals(other) && this.logTimestampMillis == this.logTimestampMillis && Utils.equalsNullSafe(this.logMessage, ((LogEvent)other).logMessage);
    }
}

