/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.ObjectEvent;
import com.streamscape.sdo.utils.SDOUtils;

public final class KafkaEvent
extends ObjectEvent {
    public static final String TOPIC_NAME_PROPERTY = "topicName";
    private Object key = null;
    private static final String KEY = "//key/";

    protected KafkaEvent() {
        this.initProperties();
    }

    protected KafkaEvent(String eventId) throws SDOFormatException {
        super(eventId);
        this.initProperties();
    }

    protected void initProperties() {
        try {
            this.setEventStringProperty(TOPIC_NAME_PROPERTY, "");
        }
        catch (Exception exception) {
            throw new SDORuntimeException("Adding properties failed.", exception);
        }
    }

    public String getTopicName() {
        try {
            return this.getEventStringProperty(TOPIC_NAME_PROPERTY);
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setTopicName(String topicName) {
        try {
            this.setEventStringProperty(TOPIC_NAME_PROPERTY, topicName);
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object getKey() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        return this.key != null ? SDOUtils.clone(this.key) : this.key;
    }

    public synchronized void setKey(Object newKey) throws SecurityViolationException {
        if (newKey != null) {
            this.assertState();
            this.assertWriteAccess();
            this.key = newKey;
        }
    }

    public Object getValue() throws SecurityViolationException, SDOException {
        return this.getData();
    }

    public void setValue(Object newValue) throws SDOException, SecurityViolationException {
        this.setData(newValue);
    }

    @Override
    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException, TypeAnalyzerException {
        Class<?> keyClass;
        Class<?> clazz = keyClass = this.key != null ? this.key.getClass() : null;
        if (sdrPath.equals("//key")) {
            return keyClass;
        }
        if (sdrPath.startsWith(KEY)) {
            return keyClass != null ? TypeAnalyzerFactory.getInstance().createTypeAnalyzer().getFieldClass(keyClass, "//" + sdrPath.substring(KEY.length())) : null;
        }
        return super.getPropertyClass(sdrPath);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof KafkaEvent && super.equals(other) && SDOUtils.equals(this.key, ((KafkaEvent)other).key);
    }
}

