/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.FileEventType;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sdo.file.FileMetaInfo;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;

public final class FileEvent
extends AbstractMutableEvent
implements EventDatagram {
    protected static final String NAME_PROPERTY = "FileName";
    protected static final String PATH_PROPERTY = "FilePath";
    protected static final String DATE_PROPERTY = "FileModifiedTime";
    protected static final String STATE_PROPERTY = "FileState";
    protected static final String EVENT_TYPE_PROPERTY = "FileEventType";
    protected static final String SIZE_PROPERTY = "FileSize";
    protected static final String ABSOLUTE_FILE_NAME_PROPERTY = "AbsoluteFileName";
    protected static final String RELATIVE_FILE_NAME_PROPERTY = "RelativeFileName";
    protected static final String SIZE_DELTA_PROPERTY = "FileSizeDelta";
    protected static final String IS_DIRECTORY_PROPERTY = "IsDirectory";
    protected static final String FILE_TYPE_PROPERTY = "FileType";
    protected byte[] fileData;

    protected FileEvent() {
    }

    protected FileEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public String getPath() throws SecurityViolationException {
        return (String)this.getSecureProperty(PATH_PROPERTY);
    }

    public String getName() throws SecurityViolationException {
        return (String)this.getSecureProperty(NAME_PROPERTY);
    }

    public String getRelativeFileName() throws SecurityViolationException {
        return (String)this.getSecureProperty(RELATIVE_FILE_NAME_PROPERTY);
    }

    public void setRelativeFileName(String fileName) throws SecurityViolationException {
        this.setSecureProperty(RELATIVE_FILE_NAME_PROPERTY, fileName);
    }

    public long getLastModifiedTime() throws SecurityViolationException {
        return (Long)this.getSecureProperty(DATE_PROPERTY);
    }

    public void setLastModifiedTime(Date ts) throws SecurityViolationException {
        this.setSecureProperty(DATE_PROPERTY, ts.getTime());
    }

    public long getSize() throws SecurityViolationException {
        return (Long)this.getSecureProperty(SIZE_PROPERTY);
    }

    public void setSize(long size) throws SecurityViolationException {
        this.setSecureProperty(SIZE_PROPERTY, size);
    }

    public FileState getLastState() throws SecurityViolationException {
        return FileState.valueOf((String)this.getSecureProperty(STATE_PROPERTY));
    }

    public void setLastState(FileState state) throws SecurityViolationException {
        this.setSecureProperty(STATE_PROPERTY, state.name());
    }

    public String getAbsoluteFileName() throws SecurityViolationException {
        return (String)this.getSecureProperty(ABSOLUTE_FILE_NAME_PROPERTY);
    }

    public FileEventType getEventType() throws SecurityViolationException {
        return FileEventType.valueOf((String)this.getSecureProperty(EVENT_TYPE_PROPERTY));
    }

    public long getSizeDelta() throws SecurityViolationException {
        return (Long)this.getSecureProperty(SIZE_DELTA_PROPERTY);
    }

    public void setSizeDelta(long delta) throws SecurityViolationException {
        this.setSecureProperty(SIZE_DELTA_PROPERTY, delta);
    }

    public String getFileType() throws SecurityViolationException {
        return (String)this.getSecureProperty(FILE_TYPE_PROPERTY);
    }

    public String getFileExtension() throws SecurityViolationException {
        String type = (String)this.getSecureProperty(FILE_TYPE_PROPERTY);
        return type.toLowerCase();
    }

    public void setFileType(String type) throws SecurityViolationException {
        this.setSecureProperty(FILE_TYPE_PROPERTY, type);
    }

    public byte[] getFileData() throws SecurityViolationException {
        this.assertReadAccess();
        this.cloneReturnDataSafe();
        return this.fileData;
    }

    public void setFileData(byte[] fileData) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.fileData = fileData;
        this.resetDataCounter();
    }

    public void init(FileMetaInfo fileState) throws SecurityViolationException {
        this.setSecureProperty(NAME_PROPERTY, fileState.getName());
        this.setSecureProperty(PATH_PROPERTY, fileState.getPath());
        this.setSecureProperty(EVENT_TYPE_PROPERTY, fileState.getEventType().name());
        this.setSecureProperty(ABSOLUTE_FILE_NAME_PROPERTY, fileState.getAbsoluteFileName());
        this.setSecureProperty(IS_DIRECTORY_PROPERTY, fileState.isDirectory());
        this.setLastModifiedTime(fileState.getLastModifiedAsDate());
        this.setLastState(fileState.getLastState());
        this.setSize(fileState.getSize());
        this.setSizeDelta(fileState.getSizeDelta());
        if (fileState.getRelativeFileName() != null) {
            this.setRelativeFileName(fileState.getRelativeFileName());
        }
        this.setFileType(FilenameUtils.getExtension(fileState.getName()));
    }

    public void init(File file, FileState state) throws SecurityViolationException, SDOException {
        FileMetaInfo fileState = new FileMetaInfo(file, state);
        this.init(fileState);
    }

    protected Object getSecureProperty(String propertyName) throws SecurityViolationException {
        this.assertReadAccess();
        try {
            return this.getEventObjectProperty(propertyName);
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void setSecureProperty(String propertyName, Object value) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        try {
            this.setEventObjectProperty(propertyName, value);
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return null;
    }

    static FileEvent createPrototype() {
        try {
            FileEvent result = new FileEvent();
            result.setEventStringProperty(NAME_PROPERTY, "");
            result.setEventStringProperty(PATH_PROPERTY, "");
            result.setEventLongProperty(DATE_PROPERTY, 0L);
            result.setEventStringProperty(STATE_PROPERTY, "");
            result.setEventStringProperty(EVENT_TYPE_PROPERTY, "");
            result.setEventLongProperty(SIZE_PROPERTY, 0L);
            result.setEventStringProperty(ABSOLUTE_FILE_NAME_PROPERTY, "");
            result.setEventStringProperty(RELATIVE_FILE_NAME_PROPERTY, "");
            result.setEventLongProperty(SIZE_DELTA_PROPERTY, 0L);
            result.setEventBooleanProperty(IS_DIRECTORY_PROPERTY, false);
            result.setEventStringProperty(FILE_TYPE_PROPERTY, "");
            return result;
        }
        catch (Exception ignored) {
            throw new RuntimeException("Creation of FileEvent prototype failed.");
        }
    }

    @Override
    protected void doCloneReturnData() {
        if (this.fileData != null) {
            this.fileData = (byte[])this.fileData.clone();
        }
    }

    @Override
    public void addAnnotation(String propertyName, String sdrPath) throws SecurityViolationException, SDOException {
        throw new SDOException("FileEvent does not support annotation.");
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof FileEvent && super.equals(other) && Arrays.equals(this.fileData, ((FileEvent)other).fileData);
    }
}

