/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sef.utils.Utils;
import java.util.Arrays;

public final class ExceptionEvent
extends AbstractMutableEvent
implements EventDatagram,
ExceptionEventDatagram {
    public static final String DEFAULT_EVENT_ID = "event.exception";
    protected byte[] eventSink = null;
    protected int errorCode = 0;
    protected String errorMessage = null;
    protected Severity severity = null;

    protected ExceptionEvent() {
    }

    protected ExceptionEvent(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    protected ExceptionEvent(int errorCode, String errorMessage, Severity severity) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.severity = severity;
    }

    @Override
    public void setErrorCode(int code) {
        this.assertState();
        this.errorCode = code;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorCodeAsString() {
        return Integer.toString(this.errorCode);
    }

    @Override
    public void setSeverity(Severity severity) {
        this.assertState();
        this.severity = severity;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    public void setErrorMessage(String errorMessage) {
        this.assertState();
        this.errorMessage = errorMessage;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public byte[] getEventSink() {
        return this.eventSink != null ? (byte[])this.eventSink.clone() : null;
    }

    @Override
    public void setEventSink(byte[] eventSink) {
        this.assertState();
        this.eventSink = eventSink;
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException {
        return null;
    }

    @Override
    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException {
        if (sdrPath.equals("//errorMessage") || sdrPath.equals("//severity")) {
            return String.class;
        }
        if (sdrPath.equals("//errorCode")) {
            return Integer.class;
        }
        throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath));
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof ExceptionEvent && super.equals(other) && Arrays.equals(this.eventSink, ((ExceptionEvent)other).eventSink) && this.errorCode == ((ExceptionEvent)other).errorCode && Utils.equalsNullSafe(this.errorMessage, ((ExceptionEvent)other).errorMessage) && Utils.equalsNullSafe((Object)this.severity, (Object)((ExceptionEvent)other).severity);
    }
}

