/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.Trace;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.SerializerSupportException;
import com.streamscape.omf.serializer.SerializerFactory;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.AuditEvent;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.ExceptionEvent;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.event.KafkaEvent;
import com.streamscape.sdo.event.LogEvent;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.event.ObjectEvent;
import com.streamscape.sdo.event.RowArrayEvent;
import com.streamscape.sdo.event.RowChangeEvent;
import com.streamscape.sdo.event.RowEvent;
import com.streamscape.sdo.event.RowSetEvent;
import com.streamscape.sdo.event.StreamEvent;
import com.streamscape.sdo.event.StreamStateEvent;
import com.streamscape.sdo.event.TextEvent;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.event.XMPPEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricEventSourceException;

public class EventDatagramFactory
extends IAbstractDatagramFactory {
    private static EventDatagramFactory instance = null;

    protected EventDatagramFactory() {
        super("EventDatagramFactory", "datagram");
        Trace.logDebug(this, "Instantiated Event Datagram factory.");
    }

    @Override
    protected void addDatagramEntries() {
        this.addDatagramEntry(new DataEvent(), "Core data event object.");
        this.addDatagramEntry(XMPPEvent.createPrototype(), "XMPP event object.");
        this.addDatagramEntry(new XMLEvent(), "XML event object.");
        this.addDatagramEntry(new RowArrayEvent(), "RowArray event object.");
        this.addDatagramEntry(new RowSetEvent(), "RowSet event object.");
        this.addDatagramEntry(new RowEvent(), "Row event object.");
        this.addDatagramEntry(new RowChangeEvent(), "RowChange event object.");
        this.addDatagramEntry(FileEvent.createPrototype(), "File event object.");
        this.addDatagramEntry(new AuditEvent(), "Audit event object.");
        this.addDatagramEntry(new TextEvent(), "Text event object.");
        this.addDatagramEntry(new AcknowledgementEvent(), "Core acknowledgement datagram object.");
        this.addDatagramEntry(new DeltaEvent(), "Core delta event datagram object.");
        this.addDatagramEntry(new StreamStateEvent(), "Stream State event datagram object.");
        this.addDatagramEntry(new BytesEvent(), "Bytes event datagram object.");
        this.addDatagramEntry(new ExceptionEvent(), "Exception event datagram object.");
        this.addDatagramEntry(new MapEvent(), "Map event datagram object.");
        this.addDatagramEntry(new MailEvent(), "Mail event datagram object.");
        this.addDatagramEntry(new StreamEvent(), "Streaming event datagram object.");
        this.addDatagramEntry(new ObjectEvent(), "Object event datagram object.");
        this.addDatagramEntry(new KafkaEvent(), "Kafka event datagram object.");
        this.addDatagramEntry(new LogEvent(), "Log event datagram object.");
    }

    @Override
    public void initSerializer(SerializerFactory factory, String serializerName) throws SerializerSupportException {
        if (factory instanceof XSerializerFactory) {
            XSerializer xserializer = (XSerializer)factory.lookupSerializer(serializerName);
            xserializer.getDefaultsProvider().setFieldDefault("eventSource", byte[].class, IAbstractDataEvent.class, new byte[0]);
            xserializer.getDefaultsProvider().setFieldStringDefault("eventId", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("eventKey", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("eventGroupId", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldDefault("correlationId", byte[].class, IAbstractDataEvent.class, new byte[0]);
            xserializer.getDefaultsProvider().setFieldStringDefault("eventReplyTo", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("principal", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("eventForwardTo", String.class, IAbstractDataEvent.class, "");
            xserializer.getDefaultsProvider().setFieldDefault("credential", byte[].class, IAbstractDataEvent.class, new byte[0]);
        }
    }

    public static EventDatagramFactory getInstance() {
        if (instance == null) {
            instance = new EventDatagramFactory();
        }
        return instance;
    }

    public AcknowledgementEvent createAcknowledgement(EventDatagram event) throws DatagramFactoryException {
        return this.createAcknowledgement(event, false);
    }

    public AcknowledgementEvent createAcknowledgement(EventDatagram event, boolean withSourceData) throws DatagramFactoryException {
        String resultEventId = null;
        try {
            AcknowledgementEvent result;
            resultEventId = event.getReplyTo();
            if (resultEventId == null) {
                throw new DatagramFactoryException(5038, "Event field 'ReplyTo' is null.");
            }
            if (resultEventId.startsWith("e.reply.") || resultEventId.startsWith("e.sys.reply.")) {
                result = (AcknowledgementEvent)this.createEvent("e.prototype.AcknowledgementEvent");
                result.setEventId(resultEventId);
            } else {
                result = (AcknowledgementEvent)this.createEvent(resultEventId);
            }
            if (withSourceData) {
                this.setAcknowledgementSourceData(event, result);
            }
            result.setCorrelationEventId(event.getEventId());
            result.setCorrelationEventSource(event.getEventSource());
            result.setCorrelationEventTimeStamp(event.getTimestamp());
            result.setCorrelationIdAsBytes(event.getCorrelationIdAsBytes());
            return result;
        }
        catch (ClassCastException exception) {
            throw new DatagramFactoryException(5038, "Event id [" + resultEventId + "] is not an AcknowledgementEvent.");
        }
        catch (SDOException exception) {
            throw new DatagramFactoryException(5038, "Creation of Acknowledgement failed.", exception);
        }
        catch (SecurityViolationException exception) {
            throw new DatagramFactoryException(5038, "Acknowledgement security violation.", exception);
        }
        catch (FabricEventSourceException exception) {
            throw new DatagramFactoryException(5038, "Creation of Acknowledgement failed.", exception);
        }
    }

    public AcknowledgementEvent createAcknowledgement(String eventId) throws DatagramFactoryException {
        try {
            if (eventId.startsWith("e.reply.") || eventId.startsWith("e.sys.reply.")) {
                AcknowledgementEvent result = (AcknowledgementEvent)this.createEvent("e.prototype.AcknowledgementEvent");
                result.setEventId(eventId);
                return result;
            }
            return (AcknowledgementEvent)this.createEvent(eventId);
        }
        catch (ClassCastException exception) {
            throw new DatagramFactoryException(5038, "Event id [" + eventId + "] is not an AcknowledgementEvent.");
        }
        catch (SDOException exception) {
            throw new DatagramFactoryException(5038, "Creation of Acknowledgement failed.", exception);
        }
    }

    public AcknowledgementEvent createAcknowledgement(ExceptionEventDatagram event) throws DatagramFactoryException {
        String resultEventId = null;
        try {
            AcknowledgementEvent result;
            resultEventId = event.getReplyTo();
            if (resultEventId == null) {
                throw new DatagramFactoryException(5038, "Event field 'ReplyTo' is null.");
            }
            if (resultEventId.startsWith("e.reply.") || resultEventId.startsWith("e.sys.reply.")) {
                result = (AcknowledgementEvent)this.createEvent("e.prototype.AcknowledgementEvent");
                result.setEventId(resultEventId);
            } else {
                result = (AcknowledgementEvent)this.createEvent(resultEventId);
            }
            result.setCorrelationEventId(event.getEventId());
            result.setCorrelationEventSource(event.getEventSource());
            result.setCorrelationEventTimeStamp(event.getTimestamp());
            result.setCorrelationIdAsBytes(event.getCorrelationIdAsBytes());
            return result;
        }
        catch (ClassCastException exception) {
            throw new DatagramFactoryException(5038, "Event id [" + resultEventId + "] is not an AcknowledgementEvent.");
        }
        catch (SDOException exception) {
            throw new DatagramFactoryException(5038, "Creation of Acknowledgement failed.", exception);
        }
        catch (SecurityViolationException exception) {
            throw new DatagramFactoryException(5038, "Acknowledgement security violation.", exception);
        }
    }

    @Override
    public EventDatagram createEvent(Prototype prototype) throws DatagramFactoryException {
        EventDatagram event = (EventDatagram)super.createEvent(prototype);
        if (event instanceof XMLEvent) {
            try {
                ((XMLEvent)event).initSerializer(XSerializerFactory.getInstance().getXMLEventSerializer(event.getEventId()));
            }
            catch (FactoryManagerException exception) {
                throw new DatagramFactoryException(exception.getErrorCode(), (Throwable)exception);
            }
        }
        return event;
    }

    @Override
    public EventDatagram createEvent(String eventId) throws DatagramFactoryException {
        EventDatagram event = (EventDatagram)super.createEvent(eventId);
        if (event instanceof XMLEvent) {
            try {
                ((XMLEvent)event).initSerializer(XSerializerFactory.getInstance().getXMLEventSerializer(eventId));
            }
            catch (FactoryManagerException exception) {
                throw new DatagramFactoryException(exception.getErrorCode(), (Throwable)exception);
            }
        }
        return event;
    }

    @Override
    public EventDatagram cloneEvent(ImmutableEventDatagram event) throws DatagramFactoryException {
        return (EventDatagram)super.cloneEvent(event);
    }

    @Override
    public EventDatagram newEventInstance(SemanticType type) throws DatagramFactoryException {
        return (EventDatagram)super.newEventInstance(type);
    }

    @Override
    public EventDatagram newEventInstance(String semanticType) throws DatagramFactoryException {
        return (EventDatagram)super.newEventInstance(semanticType);
    }

    @Override
    public EventDatagram newEventInstanceFrom(String eventId) throws DatagramFactoryException {
        return (EventDatagram)super.newEventInstanceFrom(eventId);
    }

    @Override
    public EventDatagram newEventInstanceFrom(ImmutableEventDatagram event) throws DatagramFactoryException {
        return (EventDatagram)super.newEventInstanceFrom(event);
    }

    @Override
    protected void loadRegisteredPrototypes() throws DatagramFactoryException, SDOException {
        super.loadRegisteredPrototypes();
    }

    @Override
    protected void addSupportedTypes() throws DatagramFactoryException {
        super.addSupportedTypes();
    }

    @Override
    protected void resetData(ImmutableEventDatagram event) {
        if (event instanceof DataEvent) {
            ((DataEvent)event).data = null;
        } else if (event instanceof DeltaEvent) {
            ((DeltaEvent)event).beforeImage = null;
            ((DeltaEvent)event).afterImage = null;
        }
    }

    @Override
    protected void resetData(ImmutableEventDatagram event, SemanticType dataType) throws Exception {
        if (event instanceof DataEvent) {
            ((DataEvent)event).setData(SDOUtils.createDataObject(dataType));
        } else if (event instanceof DeltaEvent) {
            ((DeltaEvent)event).setBeforeImage(SDOUtils.createDataObject(dataType));
            ((DeltaEvent)event).setAfterImage(SDOUtils.createDataObject(dataType));
        }
    }
}

