/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.sdo.DeltaEventDatagram;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AbstractPayloadEvent;
import com.streamscape.sdo.utils.SDOUtils;
import java.util.List;
import java.util.Map;

public final class DeltaEvent
extends AbstractPayloadEvent
implements DeltaEventDatagram,
PayloadEvent {
    protected Object beforeImage = null;
    protected Object afterImage = null;
    protected transient Class dataClass = null;
    private static final String BEFORE_IMAGE = "//beforeImage/";
    private static final String AFTER_IMAGE = "//afterImage/";

    protected DeltaEvent() {
    }

    protected DeltaEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    @Override
    public Class getPayloadClass() {
        if (this.dataClass == null) {
            if (this.beforeImage != null) {
                this.dataClass = this.beforeImage.getClass();
            } else if (this.afterImage != null) {
                this.dataClass = this.afterImage.getClass();
            }
        }
        return this.dataClass;
    }

    @Override
    public Object getBeforeImage() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        this.cloneReturnData();
        return this.beforeImage;
    }

    @Override
    public synchronized void setBeforeImage(Object newImage) throws SDOException, SecurityViolationException {
        if (newImage == null) {
            throw new SDOException("Before image object is null.");
        }
        this.assertState();
        this.assertWriteAccess();
        DeltaEvent.checkPayloadType(this, newImage);
        if (this.dataClass != newImage.getClass()) {
            this.dataClass = newImage.getClass();
        }
        this.beforeImage = newImage;
    }

    @Override
    public Object getAfterImage() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        this.cloneReturnData();
        return this.afterImage;
    }

    @Override
    public synchronized void setAfterImage(Object newImage) throws SDOException, SecurityViolationException {
        if (newImage == null) {
            throw new SDOException("After image object is null.");
        }
        this.assertState();
        this.assertWriteAccess();
        DeltaEvent.checkPayloadType(this, newImage);
        if (this.dataClass != newImage.getClass()) {
            this.dataClass = newImage.getClass();
        }
        this.afterImage = newImage;
    }

    @Override
    protected void doCloneReturnData() throws SDOException {
        this.beforeImage = SDOUtils.clone(this.beforeImage);
        this.afterImage = SDOUtils.clone(this.afterImage);
    }

    @Override
    public boolean equals() {
        return this.beforeImage == null ? this.afterImage == null : this.beforeImage.equals(this.afterImage);
    }

    @Override
    public List<String> getDeltaElements() {
        return null;
    }

    @Override
    public Map<String, Object> getDeltas() {
        return null;
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return this.getAfterImage();
    }

    @Override
    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException, TypeAnalyzerException {
        if (this.dataClass == null) {
            if (this.beforeImage != null) {
                this.dataClass = this.beforeImage.getClass();
            } else if (this.afterImage != null) {
                this.dataClass = this.afterImage.getClass();
            } else {
                throw new SDOPropertyException("Image objects are null.");
            }
        }
        if (sdrPath.equals("//beforeImage")) {
            return this.dataClass;
        }
        if (sdrPath.equals("//afterImage")) {
            return this.dataClass;
        }
        if (sdrPath.startsWith(BEFORE_IMAGE)) {
            return TypeAnalyzerFactory.getInstance().createTypeAnalyzer().getFieldClass(this.dataClass, "//" + sdrPath.substring(BEFORE_IMAGE.length()));
        }
        if (sdrPath.startsWith(AFTER_IMAGE)) {
            return TypeAnalyzerFactory.getInstance().createTypeAnalyzer().getFieldClass(this.dataClass, "//" + sdrPath.substring(AFTER_IMAGE.length()));
        }
        throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath));
    }

    private Object readResolve() {
        if (this.beforeImage != null) {
            this.dataClass = this.beforeImage.getClass();
        } else if (this.afterImage != null) {
            this.dataClass = this.afterImage.getClass();
        }
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof DeltaEvent && super.equals(other) && SDOUtils.equals(this.beforeImage, ((DeltaEvent)other).beforeImage) && SDOUtils.equals(this.afterImage, ((DeltaEvent)other).afterImage);
    }
}

