/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.streamscape.Trace;
import com.streamscape.cli.http.HTTPEventFactory;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.MapJsonParser;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.event.AbstractPayloadEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.Arrays;
import java.util.Map;

public class DataEvent
extends AbstractPayloadEvent
implements EventDatagram,
PayloadEvent {
    protected Object data = null;
    protected transient Class dataClass = null;
    private static final String DATA = "//data/";

    protected DataEvent() {
    }

    protected DataEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public synchronized void setData(Object newData) throws SecurityViolationException, SDOException {
        if (newData == null) {
            throw new SDOException("Data object is null.");
        }
        this.assertState();
        this.assertWriteAccess();
        DataEvent.checkPayloadType(this, newData);
        if (this.dataClass != newData.getClass()) {
            this.dataClass = newData.getClass();
        }
        this.data = newData;
        this.resetDataCounter();
    }

    @Override
    public void checkPayloadClass(Class payloadClass) throws SDOException {
        if (payloadClass.equals(Object.class)) {
            throw new SDOException("DataEvent cannot accept Object as a payload. Use ObjectEvent instead.");
        }
    }

    @Override
    public Class getPayloadClass() {
        if (this.dataClass == null && this.data != null) {
            this.dataClass = this.data.getClass();
        }
        return this.dataClass;
    }

    public Object getData() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        this.cloneReturnData();
        return this.data;
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return this.getData();
    }

    @Override
    protected void doCloneReturnData() throws SDOException {
        this.data = SDOUtils.clone(this.data);
    }

    @Override
    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException, TypeAnalyzerException {
        if (this.dataClass == null) {
            if (this.data != null) {
                this.dataClass = this.data.getClass();
            } else {
                throw new SDOPropertyException("Data object is null.");
            }
        }
        if (sdrPath.equals("//data")) {
            return this.dataClass;
        }
        if (sdrPath.startsWith(DATA)) {
            return TypeAnalyzerFactory.getInstance().createTypeAnalyzer().getFieldClass(this.dataClass, "//" + sdrPath.substring(DATA.length()));
        }
        throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath));
    }

    private Object readResolve() {
        if (this.data != null) {
            this.dataClass = this.data.getClass();
        }
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof DataEvent && super.equals(other) && SDOUtils.equals(this.data, ((DataEvent)other).data);
    }

    private void setDataFromJackson(Object newData) throws SDOException, SecurityViolationException {
        if (newData == null) {
            return;
        }
        boolean isHttpImport = false;
        EventDatagram event = null;
        if (this.eventId != null) {
            HTTPEventFactory eventFactory = HTTPEventFactory.getCurrentThreadFactory();
            if (eventFactory != null) {
                try {
                    event = (EventDatagram)eventFactory.createEvent(this.eventId, false);
                }
                catch (HTTPFabricException exception) {
                    Trace.logException(this, exception, true);
                }
            }
            if (event == null && !(isHttpImport = DataEvent.isHttpImport()) && AbstractFabricContextFactory.hasContext()) {
                try {
                    event = EventDatagramFactory.getInstance().createEvent(this.eventId);
                }
                catch (DatagramFactoryException exception) {
                    // empty catch block
                }
            }
        }
        if (event != null) {
            if (!(event instanceof DataEvent)) {
                throw new SDOException("Invalid event prototype. Should be DataEvent.");
            }
            Class eventPayloadClass = ((DataEvent)event).getPayloadClass();
            if (!newData.getClass().getName().equals(eventPayloadClass.getName())) {
                PropertyType type = PropertyType.resolveType(eventPayloadClass);
                if (type != null) {
                    newData = TypeFactory.convertPropertyValue(type, newData);
                } else if (eventPayloadClass == byte[].class && newData instanceof String) {
                    newData = Base64Variants.MIME.decode((String)newData);
                }
            }
            if (newData != null && !newData.getClass().getName().equals(eventPayloadClass.getName())) {
                if (RuntimeState.isActive() && newData instanceof Map) {
                    try {
                        JSONSerializer serializer = HTTPUtils.getJsonSerializerForRest(FormatAndMimeTypes.JSON_SWAGGER);
                        newData = serializer.deserialize(eventPayloadClass, (JsonParser)new MapJsonParser((Map)newData));
                    }
                    catch (Exception exception) {
                        throw new SDOException("Event data deserialization to class '" + eventPayloadClass.getName() + "' failed. Map data: " + String.valueOf(newData), exception);
                    }
                } else if (newData instanceof Map) {
                    try {
                        newData = JSONSerializer.getContextJsonSerializer().deserialize(eventPayloadClass, (JsonParser)new MapJsonParser((Map)newData));
                    }
                    catch (Exception exception) {
                        throw new SDOException("Event data deserialization to class '" + eventPayloadClass.getName() + "' failed. Map data: " + String.valueOf(newData), exception);
                    }
                } else {
                    DataEvent.throwInvalidPayloadType(eventPayloadClass, newData.getClass());
                }
            }
            this.dataClass = newData.getClass();
            this.data = newData;
            this.dataCounter = null;
        } else if (this.eventId == null || isHttpImport) {
            this.dataClass = newData.getClass();
            this.data = newData;
            this.dataCounter = null;
        } else {
            throw new SDOException("Event prototype for [" + this.eventId + "] not found. Payload type and object cannot be defined.");
        }
    }

    private static boolean isHttpImport() {
        return Arrays.stream(new Exception().getStackTrace()).anyMatch(s -> s.getMethodName().equals("invokeImportEventPrototypeRequest") && s.getClassName().equals(HTTPFabricConnection.class.getName()));
    }
}

