/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.event.BytesEvent;

public final class ChunkEvent
extends BytesEvent {
    public static final String CHUNK_NUMBER_PROPERTY = "chunkNumber";

    protected ChunkEvent(String eventId) {
        this.initProperties();
        this.eventId = eventId;
    }

    protected void initProperties() {
        try {
            this.setEventIntProperty(CHUNK_NUMBER_PROPERTY, -1);
        }
        catch (Exception exception) {
            throw new SDORuntimeException("Adding properties failed.", exception);
        }
    }

    public String getStreamEventId() {
        return ChunkEvent.getStreamEventId(this.eventId);
    }

    public int getChunkNumber() {
        try {
            return this.getEventIntProperty(CHUNK_NUMBER_PROPERTY);
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    void setChunkNumber(int chunkNumber) {
        try {
            this.setEventIntProperty(CHUNK_NUMBER_PROPERTY, chunkNumber);
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String getEventId(String streamingEventId) {
        return "e.chunk." + streamingEventId;
    }

    public static String getStreamEventId(String chunkEventId) {
        return chunkEventId.substring("e.chunk.".length());
    }
}

