/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.Trace;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sef.exchange.FabricAddress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class BytesEvent
extends AbstractMutableEvent
implements EventDatagram {
    private byte[] data;
    private boolean readOnly = false;
    private transient DataInputStream inputStream;
    private transient DataOutputStream outputStream;
    private transient ByteArrayOutputStream outputBytesStream;

    protected BytesEvent() {
    }

    protected BytesEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public synchronized void setBytes(byte[] data) throws SecurityViolationException, SDOException {
        this.checkWriteAccess();
        this.data = data;
        this.outputStream = null;
        this.outputBytesStream = null;
        this.resetDataCounter();
    }

    public synchronized byte[] getBytes() throws SecurityViolationException {
        this.assertReadAccess();
        if (this.outputBytesStream != null) {
            return this.outputBytesStream.toByteArray();
        }
        if (this.isProtected() && this.getWriteAccess() != 37) {
            return this.data != null ? (byte[])this.data.clone() : null;
        }
        return this.data;
    }

    public long getBytesLength() throws SecurityViolationException {
        this.assertReadAccess();
        if (this.outputStream != null) {
            return this.outputStream.size();
        }
        return this.data != null ? (long)this.data.length : 0L;
    }

    public boolean readBoolean() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readBoolean();
        }
        catch (IOException exception) {
            throw this.newReadingException("boolean", exception);
        }
    }

    public byte readByte() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readByte();
        }
        catch (IOException exception) {
            throw this.newReadingException("byte", exception);
        }
    }

    public int readUnsignedByte() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readUnsignedByte();
        }
        catch (IOException exception) {
            throw this.newReadingException("unsigned byte", exception);
        }
    }

    public short readShort() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readShort();
        }
        catch (IOException exception) {
            throw this.newReadingException("short", exception);
        }
    }

    public int readUnsignedShort() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readUnsignedShort();
        }
        catch (IOException exception) {
            throw this.newReadingException("unsigned short", exception);
        }
    }

    public char readChar() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readChar();
        }
        catch (IOException exception) {
            throw this.newReadingException("char", exception);
        }
    }

    public int readInt() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readInt();
        }
        catch (IOException exception) {
            throw this.newReadingException("int", exception);
        }
    }

    public long readLong() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readLong();
        }
        catch (IOException exception) {
            throw this.newReadingException("long", exception);
        }
    }

    public float readFloat() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readFloat();
        }
        catch (IOException exception) {
            throw this.newReadingException("float", exception);
        }
    }

    public double readDouble() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readDouble();
        }
        catch (IOException exception) {
            throw this.newReadingException("double", exception);
        }
    }

    public String readUTF() throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            return this.inputStream.readUTF();
        }
        catch (IOException exception) {
            throw this.newReadingException("UTF", exception);
        }
    }

    public int readBytes(byte[] value) throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            if (this.inputStream.available() == 0) {
                return -1;
            }
            int nReadBytes = Math.min(value.length, this.inputStream.available());
            this.inputStream.readFully(value, 0, nReadBytes);
            return nReadBytes;
        }
        catch (IOException exception) {
            throw this.newReadingException("bytes", exception);
        }
    }

    public int readBytes(byte[] value, int length) throws SecurityViolationException, SDOException {
        this.prepareReading();
        try {
            if (this.inputStream.available() == 0) {
                return -1;
            }
            int nReadBytes = Math.min(length, this.inputStream.available());
            this.inputStream.readFully(value, 0, nReadBytes);
            return nReadBytes;
        }
        catch (IOException exception) {
            throw this.newReadingException("bytes", exception);
        }
    }

    protected SDOException newReadingException(String type, Exception exception) {
        return new SDOException("Stream read error. Type " + type + " for event [" + this.eventId + "].", exception);
    }

    public void writeBoolean(boolean value) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        try {
            this.outputStream.writeBoolean(value);
        }
        catch (IOException exception) {
            throw this.newWritingException("boolean", exception);
        }
    }

    public void writeByte(byte value) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        try {
            this.outputStream.writeByte(value);
        }
        catch (IOException exception) {
            throw this.newWritingException("byte", exception);
        }
    }

    public void writeShort(short value) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        try {
            this.outputStream.writeShort(value);
        }
        catch (IOException exception) {
            throw this.newWritingException("short", exception);
        }
    }

    public void writeChar(char value) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        try {
            this.outputStream.writeChar(value);
        }
        catch (IOException exception) {
            throw this.newWritingException("char", exception);
        }
    }

    public void writeInt(int value) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        try {
            this.outputStream.writeInt(value);
        }
        catch (IOException exception) {
            throw this.newWritingException("int", exception);
        }
    }

    public void writeLong(long value) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        try {
            this.outputStream.writeLong(value);
        }
        catch (IOException exception) {
            throw this.newWritingException("long", exception);
        }
    }

    public void writeFloat(float value) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        try {
            this.outputStream.writeFloat(value);
        }
        catch (IOException exception) {
            throw this.newWritingException("float", exception);
        }
    }

    public void writeDouble(double value) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        try {
            this.outputStream.writeDouble(value);
        }
        catch (IOException exception) {
            throw this.newWritingException("double", exception);
        }
    }

    public void writeUTF(String value) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        try {
            this.outputStream.writeUTF(value);
        }
        catch (IOException exception) {
            throw this.newWritingException("UTF", exception);
        }
    }

    public void writeBytes(byte[] value) throws SecurityViolationException, SDOException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        this.write(value, offset, length);
    }

    public void writeObject(Object value) throws SecurityViolationException, SDOException {
        this.prepareWriting();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new SDOException("Invalid data type '" + value.getClass().getName() + "' for event [" + this.eventId + "].");
        }
    }

    public void clearData() throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.data = null;
        this.inputStream = null;
        this.outputStream = null;
        this.outputBytesStream = null;
        this.readOnly = false;
    }

    public void resetData() throws SecurityViolationException {
        this.assertReadAccess();
        this.doResetData();
    }

    @Override
    protected void doCoalesce(FabricAddress sourceAddress) throws SDOException {
        super.doCoalesce(sourceAddress);
        this.doResetData();
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return this.getBytes();
    }

    protected synchronized void prepareReading() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        this.checkReadOnly();
        if (this.inputStream == null) {
            this.inputStream = new DataInputStream(new ByteArrayInputStream(this.data != null ? this.data : new byte[]{}));
        }
    }

    protected synchronized void prepareWriting() throws SecurityViolationException, SDOException {
        this.checkWriteAccess();
        if (this.outputStream == null) {
            this.createOutputStream();
            if (this.data != null) {
                this.write(this.data);
                this.data = null;
            }
            this.resetDataCounter();
        } else {
            this.cloneData();
        }
    }

    protected void checkWriteAccess() throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        this.checkWriteOnly();
    }

    protected void checkReadOnly() throws SDOException {
        if (!this.readOnly) {
            throw new SDOException("Reading of event [" + this.eventId + "] failed: data is write-only.");
        }
    }

    protected void checkWriteOnly() throws SDOException {
        if (this.readOnly) {
            throw new SDOException("Writing of event [" + this.eventId + "] failed: data is read-only.");
        }
    }

    protected void createOutputStream() {
        this.outputBytesStream = new ByteArrayOutputStream();
        this.outputStream = new DataOutputStream(this.outputBytesStream);
    }

    protected void write(byte[] value) throws SDOException {
        this.write(value, 0, value.length);
    }

    protected void write(byte[] value, int offset, int length) throws SDOException {
        try {
            this.outputStream.write(value, offset, length);
        }
        catch (IOException exception) {
            throw this.newWritingException("bytes", exception);
        }
    }

    protected SDOException newWritingException(String type, Exception exception) {
        return new SDOException("Stream write error. Type " + type + " for event [" + this.eventId + "].", exception);
    }

    protected synchronized void doResetData() {
        if (!this.readOnly && this.outputStream != null) {
            this.data = this.outputBytesStream.toByteArray();
        }
        this.inputStream = null;
        this.outputStream = null;
        this.outputBytesStream = null;
        this.readOnly = true;
    }

    @Override
    public synchronized BytesEvent clone() {
        BytesEvent result = (BytesEvent)super.clone();
        try {
            if (this.inputStream != null) {
                result.inputStream = new DataInputStream(new ByteArrayInputStream(this.data != null ? this.data : new byte[]{}));
                if (this.data != null) {
                    result.inputStream.skip(this.data.length - this.inputStream.available());
                }
            }
        }
        catch (IOException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Cloning of input stream for event [" + this.eventId + "] failed. Input stream will be reset in event clone.");
            result.inputStream = new DataInputStream(new ByteArrayInputStream(this.data != null ? this.data : new byte[]{}));
        }
        return result;
    }

    @Override
    protected void doCloneData() throws SDOException {
        try {
            if (this.outputStream != null) {
                ByteArrayOutputStream outputBytesStreamClone = new ByteArrayOutputStream();
                DataOutputStream outputStreamClone = new DataOutputStream(outputBytesStreamClone);
                outputStreamClone.write(this.outputBytesStream.toByteArray());
                this.outputStream = outputStreamClone;
                this.outputBytesStream = outputBytesStreamClone;
            }
        }
        catch (IOException exception) {
            throw new SDOException("Cloning of bytes stream failed for event [" + this.eventId + "].", exception);
        }
    }

    @Override
    protected void doCloneReturnData() throws SDOException {
        if (this.data != null) {
            this.data = (byte[])this.data.clone();
        }
    }

    @Override
    public void addAnnotation(String propertyName, String sdrPath) throws SecurityViolationException, SDOException {
        throw new SDOException("BytesEvent does not support annotation.");
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof BytesEvent && super.equals(other) && Arrays.equals(this.data, ((BytesEvent)other).data) && this.readOnly == ((BytesEvent)other).readOnly;
    }
}

