/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sef.utils.Utils;

public final class AuditEvent
extends AbstractMutableEvent
implements EventDatagram {
    public static final String DEFAULT_EVENT_ID = "event.audit";
    public static final String PROCESS_EVENT_ID = "event.audit.process";
    public static final String SQL_EVENT_ID = "event.audit.sql";
    public static final String USER_EVENT_ID = "event.audit.user";
    protected String data = null;
    protected Severity severity = Severity.GENERIC;
    protected static final String CONTENT_TYPE_PROPERTY = "contentType";
    protected static final String REFERENCE_KEY_PROPERTY = "referenceKey";

    protected AuditEvent() {
        this.addAnnotations();
        this.initContentType();
    }

    protected AuditEvent(String eventId) throws SDOFormatException {
        super(eventId);
        this.addAnnotations();
        this.initContentType();
    }

    void initContentType() {
        try {
            this.setContentType(ContentType.TEXT);
        }
        catch (Exception exception) {
            throw new SDORuntimeException("Adding property 'contentType' failed.", exception);
        }
    }

    public void setAuditData(String data) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.data = data;
    }

    public String getAuditData() throws SecurityViolationException {
        this.assertReadAccess();
        return this.data;
    }

    public void setSeverity(Severity severity) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.severity = severity;
    }

    public Severity getSeverity() throws SecurityViolationException {
        this.assertReadAccess();
        return this.severity;
    }

    public ContentType getContentType() throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertReadAccess();
        return ContentType.valueOf((String)this.getEventObjectProperty(CONTENT_TYPE_PROPERTY));
    }

    public void setContentType(ContentType type) throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        this.setProperty(CONTENT_TYPE_PROPERTY, type.name());
    }

    public String getReferenceKey() throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertReadAccess();
        return (String)this.getEventObjectProperty(REFERENCE_KEY_PROPERTY);
    }

    public void setReferenceKey(String key) throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        this.setProperty(REFERENCE_KEY_PROPERTY, key);
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException {
        return null;
    }

    protected void addAnnotations() {
        try {
            this.addAnnotationSafe("Severity", "//severity");
        }
        catch (Exception exception) {
            throw new SDORuntimeException("Adding annotation 'Severity' failed.", exception);
        }
    }

    @Override
    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException {
        if (!sdrPath.equals("//data") && !sdrPath.equals("//severity")) {
            throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath));
        }
        return String.class;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof AuditEvent && super.equals(other) && Utils.equalsNullSafe(this.data, ((AuditEvent)other).data) && Utils.equalsNullSafe((Object)this.severity, (Object)((AuditEvent)other).severity);
    }

    public static enum ContentType {
        BYTES,
        OBJECT,
        TEXT,
        XML,
        SQL,
        ROW_SET,
        MAP;

    }
}

