/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.utils.Utils;
import java.util.Arrays;
import java.util.Date;

public final class AcknowledgementEvent
extends AbstractMutableEvent
implements EventDatagram {
    private long correlationEventTimeStamp = 0L;
    private long correlationEventExpiration = 0L;
    private byte[] correlationEventSource = null;
    private String correlationEventId = null;
    private AcknowledgeAction onAcknowledgeAction = AcknowledgeAction.ACKNOWLEDGE;
    private String recipientId = null;
    private Object data;

    protected AcknowledgementEvent() {
    }

    protected AcknowledgementEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    public void setData(Object data) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.data = data;
        this.resetDataCounter();
    }

    public Object getData() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        this.cloneReturnData();
        return this.data;
    }

    public String getDataType() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        return this.data != null ? TypeFactory.resolveSemanticType(this.data.getClass()) : null;
    }

    public void setCorrelationEventTimeStamp(Date ts) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.correlationEventTimeStamp = ts.getTime();
    }

    public Date getCorrelationEventTimeStamp() throws SecurityViolationException {
        this.assertWriteAccess();
        return new Date(this.correlationEventTimeStamp);
    }

    protected void setCorrelationEventSource(byte[] eventSource) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.correlationEventSource = eventSource;
    }

    public byte[] getCorrelationEventSource() throws SecurityViolationException {
        this.assertReadAccess();
        return this.correlationEventSource != null ? (byte[])this.correlationEventSource.clone() : null;
    }

    public void setCorrelationEventId(String eventId) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.correlationEventId = eventId;
    }

    public String getCorrelationEventId() throws SecurityViolationException {
        this.assertReadAccess();
        return this.correlationEventId;
    }

    public void setCorrelationEventExpiration(long expiration) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.correlationEventExpiration = expiration;
    }

    public long getCorrelationEventExpiration() throws SecurityViolationException {
        this.assertReadAccess();
        return this.correlationEventExpiration;
    }

    public void setAction(AcknowledgeAction action) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.onAcknowledgeAction = action;
    }

    public AcknowledgeAction getAction() throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        return this.onAcknowledgeAction;
    }

    public void setRecipientID(String recipient) throws SecurityViolationException {
        this.assertState();
        this.assertWriteAccess();
        this.recipientId = recipient;
    }

    public String getRecipientID() throws SecurityViolationException {
        this.assertReadAccess();
        return this.recipientId;
    }

    @Override
    protected void doCloneReturnData() throws SDOException {
        this.data = SDOUtils.clone(this.data);
    }

    @Override
    protected Object getAcknowledgementData() throws SecurityViolationException, SDOException {
        return this.getData();
    }

    @Override
    public void addAnnotation(String propertyName, String sdrPath) throws SecurityViolationException, SDOException {
        throw new SDOException("AcknowledgementEvent does not support annotation.");
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof AcknowledgementEvent && super.equals(other) && this.correlationEventTimeStamp == ((AcknowledgementEvent)other).correlationEventTimeStamp && this.correlationEventExpiration == ((AcknowledgementEvent)other).correlationEventExpiration && Arrays.equals(this.correlationEventSource, ((AcknowledgementEvent)other).correlationEventSource) && Utils.equalsNullSafe(this.correlationEventId, ((AcknowledgementEvent)other).correlationEventId) && Utils.equalsNullSafe((Object)this.onAcknowledgeAction, (Object)((AcknowledgementEvent)other).onAcknowledgeAction) && Utils.equalsNullSafe(this.recipientId, ((AcknowledgementEvent)other).recipientId) && SDOUtils.equals(this.data, ((AcknowledgementEvent)other).data);
    }
}

