/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.MetaDataException;

abstract class AbstractRowEvent
extends AbstractMutableEvent
implements EventDatagram {
    protected AbstractRowEvent() {
    }

    protected AbstractRowEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    @Override
    protected Class<?> getPropertyClass(String sdrPath) throws SDOPropertyException {
        try {
            ColumnDescriptor column = this.getColumn(sdrPath);
            if (column != null) {
                return column.getTypeClass();
            }
        }
        catch (MetaDataException error) {
            new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath) + ": " + error.getMessage());
        }
        throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath));
    }

    protected abstract ColumnDescriptor getColumn(String var1) throws MetaDataException;

    @Override
    protected void doAddAnnotatedProperty(String propertyName, PropertyType propertyType, String sdrPath) throws SDOPropertyException {
        if (propertyType == PropertyType.BigDecimal) {
            try {
                ColumnDescriptor column = this.getColumn(sdrPath);
                if (column == null) {
                    throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath));
                }
                this.eventProperties.put(propertyName, EventPropertyValidator.makeBigDecimalTemplate(column.getPrecision(), column.getScale()));
            }
            catch (MetaDataException error) {
                new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath) + ": " + error.getMessage());
            }
        } else {
            super.doAddAnnotatedProperty(propertyName, propertyType, sdrPath);
        }
    }
}

