/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.event;

import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sdo.event.PayloadEventHelper;
import com.streamscape.sdo.mf.admin.TypeFactory;

abstract class AbstractPayloadEvent
extends AbstractMutableEvent
implements PayloadEventHelper {
    protected AbstractPayloadEvent() {
    }

    AbstractPayloadEvent(String eventId) throws SDOFormatException {
        super(eventId);
    }

    static void checkPayloadType(PayloadEventHelper event, Object newData) throws SDOException {
        if (event.getPayloadClass() != null) {
            Class dataClass = event.getPayloadClass();
            if (!event.matchesPayloadClass(dataClass, newData.getClass())) {
                AbstractPayloadEvent.throwInvalidPayloadType(dataClass, newData.getClass());
            }
        } else {
            event.checkPayloadClass(newData.getClass());
        }
    }

    @Override
    public void checkPayloadClass(Class payloadClass) throws SDOException {
    }

    @Override
    public boolean matchesPayloadClass(Class dataClass, Class newDataClass) {
        return AbstractPayloadEvent.doMatchesPayloadClass(dataClass, newDataClass);
    }

    static boolean doMatchesPayloadClass(Class dataClass, Class newDataClass) {
        return newDataClass.getName().equals(dataClass.getName());
    }

    static void throwInvalidPayloadType(Class expectedClass, Class receivedClass) throws SDOException {
        String expectedType = null;
        String receivedType = null;
        if (TypeFactory.hasContext()) {
            expectedType = TypeFactory.resolveSemanticType(expectedClass);
            receivedType = TypeFactory.resolveSemanticType(receivedClass);
        }
        throw new SDOException(ErrorMessages.format("Data object has wrong type: expected '%1$s' but received '%2$s'.", expectedType != null ? expectedType : expectedClass.getName(), receivedType != null ? receivedType : receivedClass.getName()));
    }
}

