/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.enums;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public enum PropertyType {
    Boolean,
    Byte,
    Short,
    Integer,
    Long,
    Float,
    Double,
    BigDecimal,
    String;

    public static final int DEFAULT_BIG_DECIMAL_PRECISION = 128;
    public static final int DEFAULT_BIG_DECIMAL_SCALE = 0;
    private static final ArrayList<String> TYPE_NAMES;
    private static final Map<Class, PropertyType> TYPE_CLASSES;

    public static Iterator<String> getTypes() {
        return new ArrayList<String>(TYPE_NAMES).iterator();
    }

    public static PropertyType resolveType(Class type) {
        return TYPE_CLASSES.get(type);
    }

    public static PropertyType resolveType(Object object) {
        return TYPE_CLASSES.get(object.getClass());
    }

    static {
        TYPE_NAMES = new ArrayList();
        TYPE_CLASSES = new HashMap<Class, PropertyType>();
        TYPE_NAMES.add(Boolean.name());
        TYPE_NAMES.add(Byte.name());
        TYPE_NAMES.add(Short.name());
        TYPE_NAMES.add(Integer.name());
        TYPE_NAMES.add(Long.name());
        TYPE_NAMES.add(Float.name());
        TYPE_NAMES.add(Double.name());
        TYPE_NAMES.add(BigDecimal.name());
        TYPE_NAMES.add(String.name());
        TYPE_CLASSES.put(java.lang.Boolean.TYPE, Boolean);
        TYPE_CLASSES.put(Boolean.class, Boolean);
        TYPE_CLASSES.put(java.lang.Byte.TYPE, Byte);
        TYPE_CLASSES.put(Byte.class, Byte);
        TYPE_CLASSES.put(java.lang.Short.TYPE, Short);
        TYPE_CLASSES.put(Short.class, Short);
        TYPE_CLASSES.put(java.lang.Integer.TYPE, Integer);
        TYPE_CLASSES.put(Integer.class, Integer);
        TYPE_CLASSES.put(java.lang.Long.TYPE, Long);
        TYPE_CLASSES.put(Long.class, Long);
        TYPE_CLASSES.put(java.lang.Float.TYPE, Float);
        TYPE_CLASSES.put(Float.class, Float);
        TYPE_CLASSES.put(java.lang.Double.TYPE, Double);
        TYPE_CLASSES.put(Double.class, Double);
        TYPE_CLASSES.put(BigInteger.class, BigDecimal);
        TYPE_CLASSES.put(BigDecimal.class, BigDecimal);
        TYPE_CLASSES.put(Character.TYPE, String);
        TYPE_CLASSES.put(String.class, String);
    }
}

