/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.advisory;

import com.streamscape.runtime.stats.threshold.CpuThresholdAdvisory;
import com.streamscape.runtime.stats.threshold.DiskThresholdAdvisory;
import com.streamscape.runtime.stats.threshold.MemoryThresholdAdvisory;
import com.streamscape.sdo.advisory.AdvisoryEvent;
import com.streamscape.sdo.advisory.BlockedDataspaceSessionAdvisory;
import com.streamscape.sdo.advisory.BlockedThreadAdvisory;
import com.streamscape.sdo.advisory.ComponentStateChangeAdvisory;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.advisory.DaemonServiceBlockedAdvisory;
import com.streamscape.sdo.advisory.DataspaceMetricAdvisory;
import com.streamscape.sdo.advisory.DataspaceStateAdvisory;
import com.streamscape.sdo.advisory.EventTriggerAdvisory;
import com.streamscape.sdo.advisory.HTTPClientAdvisory;
import com.streamscape.sdo.advisory.HTTPRestClientAdvisory;
import com.streamscape.sdo.advisory.JournalFileTableStateChangeAdvisory;
import com.streamscape.sdo.advisory.LogFileTableStateChangeAdvisory;
import com.streamscape.sdo.advisory.ReplicaMetricAdvisory;
import com.streamscape.sdo.advisory.ReplicaStateChangeAdvisory;
import com.streamscape.sdo.advisory.ReplicaTimeoutAdvisory;
import com.streamscape.sdo.advisory.ReplicationExceptionAdvisory;
import com.streamscape.sdo.advisory.ReplicationFailAdvisory;
import com.streamscape.sdo.advisory.ReplicationSourceMetricAdvisory;
import com.streamscape.sdo.advisory.RepositoryArtifactStateChangeAdvisory;
import com.streamscape.sdo.advisory.RepositoryStateChangeAdvisory;
import com.streamscape.sdo.advisory.RuntimeAdvisory;
import com.streamscape.sdo.advisory.ServiceMetricAdvisory;
import com.streamscape.sdo.advisory.ServiceStateAdvisory;
import com.streamscape.sdo.advisory.ThreadDeadlockAdvisory;
import com.streamscape.sdo.advisory.VirtualServerStateChangeAdvisory;
import com.streamscape.sdo.advisory.XMPPClientAdvisory;
import com.streamscape.sdo.advisory.XMPPConnectionStateChangeAdvisory;
import com.streamscape.sef.accessor.FabricComponentAccessorAdvisory;
import com.streamscape.sef.coherence.CoherenceAgentAdvisory;
import com.streamscape.sef.container.LogGenerationAdvisory;
import com.streamscape.sef.container.LogThresholdAdvisory;
import com.streamscape.sef.deploy.DeploymentAdvisory;
import com.streamscape.sef.exchange.ClientThresholdAdvisory;
import com.streamscape.sef.exchange.FabricExchangeAdvisory;
import com.streamscape.sef.moderator.FabricModeratorAdvisory;
import com.streamscape.sef.scheduler.SchedulerAdvisory;
import com.streamscape.sef.security.SecurityAdvisory;
import com.streamscape.sef.service.advisories.ServiceCallAdvisory;
import com.streamscape.tools.mnode.ManagedNodeStateAdvisory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemAdvisories {
    private static final Map<String, AdvisoryEvent> SYSTEM_ADVISORIES = new HashMap<String, AdvisoryEvent>();

    public static boolean isSystem(String eventId) {
        return SYSTEM_ADVISORIES.containsKey(eventId);
    }

    public static List<String> listEventIds() {
        return new ArrayList<String>(SYSTEM_ADVISORIES.keySet());
    }

    public static Map<String, AdvisoryEvent> getEventPrototypes() {
        return new HashMap<String, AdvisoryEvent>(SYSTEM_ADVISORIES);
    }

    static {
        SYSTEM_ADVISORIES.put("advisory.BlockedThread", new BlockedThreadAdvisory());
        SYSTEM_ADVISORIES.put("advisory.ds.BlockedSession", new BlockedDataspaceSessionAdvisory());
        SYSTEM_ADVISORIES.put("advisory.fabric.ClientThreshold", new ClientThresholdAdvisory());
        SYSTEM_ADVISORIES.put("advisory.CoherenceAgent", new CoherenceAgentAdvisory());
        SYSTEM_ADVISORIES.put("advisory.component.StateChange", new ComponentStateChangeAdvisory());
        SYSTEM_ADVISORIES.put("advisory.connection.StateChange", new ConnectionStateChangeAdvisory());
        SYSTEM_ADVISORIES.put("advisory.stats.CpuThreshold", new CpuThresholdAdvisory());
        SYSTEM_ADVISORIES.put("advisory.service.blocked", new DaemonServiceBlockedAdvisory());
        SYSTEM_ADVISORIES.put("advisory.ds.metric", new DataspaceMetricAdvisory());
        SYSTEM_ADVISORIES.put("advisory.ds.notif", new DataspaceStateAdvisory());
        SYSTEM_ADVISORIES.put("advisory.Deployment", new DeploymentAdvisory());
        SYSTEM_ADVISORIES.put("advisory.stats.DiskThreshold", new DiskThresholdAdvisory());
        SYSTEM_ADVISORIES.put("advisory.exec.EventTrigger", new EventTriggerAdvisory());
        SYSTEM_ADVISORIES.put("advisory.fabric.ComponentAccessor", new FabricComponentAccessorAdvisory());
        SYSTEM_ADVISORIES.put("advisory.fabric.Exchange", new FabricExchangeAdvisory());
        SYSTEM_ADVISORIES.put("advisory.fabric.Moderator", new FabricModeratorAdvisory());
        SYSTEM_ADVISORIES.put("advisory.client.http", new HTTPClientAdvisory());
        SYSTEM_ADVISORIES.put("advisory.client.http.rest", new HTTPRestClientAdvisory());
        SYSTEM_ADVISORIES.put("advisory.journal.file.table.StateChange", new JournalFileTableStateChangeAdvisory());
        SYSTEM_ADVISORIES.put("advisory.log.file.table.StateChange", new LogFileTableStateChangeAdvisory());
        SYSTEM_ADVISORIES.put("advisory.log.Generation", new LogGenerationAdvisory());
        SYSTEM_ADVISORIES.put("advisory.log.Threshold", new LogThresholdAdvisory());
        SYSTEM_ADVISORIES.put("advisory.tnode.State", new ManagedNodeStateAdvisory());
        SYSTEM_ADVISORIES.put("advisory.stats.MemoryThreshold", new MemoryThresholdAdvisory());
        SYSTEM_ADVISORIES.put("advisory.replication.replica.Metrics", new ReplicaMetricAdvisory());
        SYSTEM_ADVISORIES.put("advisory.replica.StateChange", new ReplicaStateChangeAdvisory());
        SYSTEM_ADVISORIES.put("advisory.replica.Timeout", new ReplicaTimeoutAdvisory());
        SYSTEM_ADVISORIES.put("advisory.replication.Fail", new ReplicationFailAdvisory());
        SYSTEM_ADVISORIES.put("advisory.replication.Exception", new ReplicationExceptionAdvisory());
        SYSTEM_ADVISORIES.put("advisory.replication.source.Metrics", new ReplicationSourceMetricAdvisory());
        SYSTEM_ADVISORIES.put("advisory.repository.StateChange", new RepositoryStateChangeAdvisory());
        SYSTEM_ADVISORIES.put("advisory.repository.ArtifactChange", new RepositoryArtifactStateChangeAdvisory());
        SYSTEM_ADVISORIES.put("advisory.Runtime", new RuntimeAdvisory());
        SYSTEM_ADVISORIES.put("advisory.Scheduler", new SchedulerAdvisory());
        SYSTEM_ADVISORIES.put("advisory.Security", new SecurityAdvisory());
        SYSTEM_ADVISORIES.put("advisory.service.Call", new ServiceCallAdvisory());
        SYSTEM_ADVISORIES.put("advisory.service.metric", new ServiceMetricAdvisory());
        SYSTEM_ADVISORIES.put("advisory.service.notif", new ServiceStateAdvisory());
        SYSTEM_ADVISORIES.put("advisory.ThreadDeadlock", new ThreadDeadlockAdvisory());
        SYSTEM_ADVISORIES.put("advisory.client.xmpp", new XMPPClientAdvisory());
        SYSTEM_ADVISORIES.put("advisory.connection.xmpp.StateChange", new XMPPConnectionStateChangeAdvisory());
        SYSTEM_ADVISORIES.put("advisory.virtual.server.StateChange", new VirtualServerStateChangeAdvisory());
    }
}

