/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.advisory;

import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.advisory.AdvisoryEvent;
import com.streamscape.sdo.enums.StateAdvisoryType;
import com.streamscape.sef.advisories.StateAdvisoryDefinition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class StateAdvisory
extends AdvisoryEvent {
    private String advisoryName = "";
    private StateAdvisoryType advisoryType = StateAdvisoryType.INFORMATION;
    private String advisoryMessage = null;
    private HashMap<String, String> advisoryProperties = new HashMap();

    public void init(StateAdvisoryDefinition advisory) throws SDOFormatException {
        this.assertState();
        this.advisoryName = advisory.getName();
        this.advisoryType = advisory.getType();
        this.advisoryProperties = advisory.getProperties();
    }

    public StateAdvisoryType getType() {
        return this.advisoryType;
    }

    public String getName() {
        return this.advisoryName;
    }

    public String getMessage() {
        return this.advisoryMessage;
    }

    public void setMessage(String message) {
        this.assertState();
        this.advisoryMessage = message;
    }

    public String getProperty(String name) {
        return this.advisoryProperties.get(name);
    }

    public void setProperty(String name, String value) {
        this.assertState();
        if (this.advisoryProperties.containsKey(name)) {
            this.cloneDataSafe();
            this.advisoryProperties.put(name, value);
        }
    }

    public boolean existsProperty(String name) {
        return this.advisoryProperties.containsKey(name);
    }

    public Set<String> getPropertyNames() {
        return this.advisoryProperties != null ? new HashSet<String>(this.advisoryProperties.keySet()) : new HashSet();
    }

    @Override
    protected void doCloneData() {
        this.advisoryProperties = this.advisoryProperties != null ? (HashMap)this.advisoryProperties.clone() : null;
    }
}

