/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.advisory;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.repository.enums.CachedEntity;
import com.streamscape.sdo.advisory.AdvisoryEvent;
import com.streamscape.sdo.enums.ArtifactState;
import com.streamscape.sdo.enums.Severity;

public final class RepositoryArtifactStateChangeAdvisory
extends AdvisoryEvent {
    public static final String EVENT_ID = "advisory.repository.ArtifactChange";
    private ArtifactState state = ArtifactState.CHANGED;
    private String message;
    private String artifactPath;
    private String artifactExtension;
    private CachedEntity entityType = CachedEntity.OBJECT;
    private Severity severity = Severity.INFO;

    public RepositoryArtifactStateChangeAdvisory() {
        this.eventId = EVENT_ID;
    }

    public ArtifactState getState() {
        return this.state;
    }

    public void setState(ArtifactState state) {
        this.assertState();
        this.state = state;
    }

    public void setMessage(String message) {
        this.assertState();
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setArtifactPath(String artifactPath) {
        this.assertState();
        this.artifactPath = artifactPath;
        this.artifactExtension = FileIOUtils.getExtension(artifactPath);
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public void setEntityType(CachedEntity entityType) {
        this.assertState();
        this.entityType = entityType;
    }

    public CachedEntity getEntityType() {
        return this.entityType;
    }

    public void setSeverity(Severity severity) {
        this.assertState();
        this.severity = severity;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getArtifactExtension() {
        return this.artifactExtension;
    }
}

