/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.advisory;

import com.streamscape.sdo.advisory.AdvisoryEvent;
import com.streamscape.sdo.enums.Unit;
import com.streamscape.sef.metrics.Metric;
import java.util.Date;

public abstract class MetricAdvisory
extends AdvisoryEvent {
    private String metricName = null;
    private String metricDescription = null;
    private long minThreshold = 0L;
    private long maxThreshold = 0L;
    private Unit units = Unit.Microseconds;
    private long metricTimeStamp = 0L;
    private long metricValue = 0L;
    private String advisoryMessage = null;
    private long resetInterval = 0L;

    public String getAdvisoryMessage() {
        return this.advisoryMessage;
    }

    public void setAdvisoryMessage(String advisoryMessage) {
        this.assertState();
        this.advisoryMessage = advisoryMessage;
    }

    public MetricAdvisory() {
    }

    protected MetricAdvisory(String eventId) {
        this.eventId = eventId;
    }

    public void init(Metric metric) {
        this.assertState();
        this.metricName = metric.getName();
        this.metricDescription = metric.getDescription();
        this.minThreshold = metric.getMinThreshold();
        this.maxThreshold = metric.getMaxThreshold();
        this.units = metric.getUnits();
        this.metricTimeStamp = metric.getMetricTimestamp().getTime();
        this.metricValue = metric.getValue();
        this.resetInterval = metric.getResetInterval();
        if (metric.isMaxThreshold()) {
            this.advisoryMessage = "Maximum threshold of " + this.maxThreshold + " (" + String.valueOf((Object)this.units) + ") has been exceeded.";
        }
        if (metric.isMinThreshold()) {
            this.advisoryMessage = "Metric is below the minimum threshold of " + this.minThreshold + " (" + String.valueOf((Object)this.units) + ").";
        }
    }

    public String getDescription() {
        return this.metricDescription;
    }

    public long getMinThreshold() {
        return this.minThreshold;
    }

    public long getMaxThreshold() {
        return this.maxThreshold;
    }

    public long getValue() {
        return this.metricValue;
    }

    public Unit getUnits() {
        return this.units;
    }

    public String getName() {
        return this.metricName;
    }

    public Date getMetricTimestamp() {
        return new Date(this.metricTimeStamp);
    }

    public long getResetInterval() {
        return this.resetInterval;
    }
}

