/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.advisory;

import com.streamscape.Trace;
import com.streamscape.omf.SerializerSupportException;
import com.streamscape.omf.serializer.SerializerFactory;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.advisory.AdvisoryEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;

public class AdvisoryDatagramFactory
extends IAbstractDatagramFactory {
    private static AdvisoryDatagramFactory instance = null;

    protected AdvisoryDatagramFactory() {
        super("AdvisoryDatagramFactory", "advisory");
        Trace.logDebug(this, "Instantiated Advisory Datagram factory.");
    }

    @Override
    protected void addDatagramEntries() {
        this.addDatagramEntry(new AdvisoryEvent(), "A base Advisory Datagram object type.");
    }

    @Override
    public void initSerializer(SerializerFactory factory, String serializerName) throws SerializerSupportException {
        if (factory instanceof XSerializerFactory) {
            XSerializer xserializer = (XSerializer)factory.lookupSerializer(serializerName);
            xserializer.getDefaultsProvider().setFieldDefault("eventSource", byte[].class, AdvisoryEvent.class, new byte[0]);
            xserializer.getDefaultsProvider().setFieldStringDefault("eventId", String.class, AdvisoryEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("eventKey", String.class, AdvisoryEvent.class, "");
            xserializer.getDefaultsProvider().setFieldStringDefault("eventGroupId", String.class, AdvisoryEvent.class, "");
            xserializer.getDefaultsProvider().setFieldDefault("correlationId", byte[].class, AdvisoryEvent.class, new byte[0]);
        }
    }

    public static AdvisoryDatagramFactory getInstance() {
        if (instance == null) {
            instance = new AdvisoryDatagramFactory();
        }
        return instance;
    }

    @Override
    public final AdvisoryEventDatagram createEvent(Prototype prototype) throws DatagramFactoryException {
        return (AdvisoryEventDatagram)super.createEvent(prototype);
    }

    @Override
    public AdvisoryEventDatagram createEvent(String eventId) throws DatagramFactoryException {
        return (AdvisoryEventDatagram)super.createEvent(eventId);
    }

    @Override
    public AdvisoryEventDatagram cloneEvent(ImmutableEventDatagram event) throws DatagramFactoryException {
        return (AdvisoryEventDatagram)super.cloneEvent(event);
    }

    @Override
    public AdvisoryEventDatagram newEventInstance(SemanticType type) throws DatagramFactoryException {
        return (AdvisoryEventDatagram)super.newEventInstance(type);
    }

    @Override
    public AdvisoryEventDatagram newEventInstance(String semanticType) throws DatagramFactoryException {
        return (AdvisoryEventDatagram)super.newEventInstance(semanticType);
    }

    @Override
    public AdvisoryEventDatagram newEventInstanceFrom(String eventId) throws DatagramFactoryException {
        return (AdvisoryEventDatagram)super.newEventInstanceFrom(eventId);
    }

    @Override
    public AdvisoryEventDatagram newEventInstanceFrom(ImmutableEventDatagram event) throws DatagramFactoryException {
        return (AdvisoryEventDatagram)super.newEventInstanceFrom(event);
    }

    @Override
    protected void loadRegisteredPrototypes() throws DatagramFactoryException, SDOException {
        super.loadRegisteredPrototypes();
    }

    @Override
    protected void addSupportedTypes() throws DatagramFactoryException {
        super.addSupportedTypes();
    }
}

