/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.utils.Utils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class IAbstractExceptionEvent
extends Exception
implements ExceptionEventDatagram {
    protected long serialVersionUID = 9969000000302071L;
    protected byte[] eventSource = null;
    protected String eventId = null;
    protected String eventKey = null;
    protected String eventGroupId = null;
    protected byte[] correlationId = null;
    protected String eventReplyTo = null;
    protected byte[] eventSink = null;
    protected String errPrefix = "OMF";
    protected int errorCode = 0;
    protected Severity severity = Severity.GENERIC;
    protected boolean durable = false;
    protected long timeStamp = 0L;
    protected boolean coalesced = false;
    protected HashMap<String, Object> eventProperties = null;

    protected IAbstractExceptionEvent() {
        super("?");
        this.init();
    }

    protected IAbstractExceptionEvent(String message) {
        super(message);
        this.init();
    }

    protected IAbstractExceptionEvent(Throwable cause) {
        super(cause.getMessage(), cause);
        this.init();
    }

    protected IAbstractExceptionEvent(String message, Throwable cause) {
        super(message, cause);
        this.init();
    }

    protected IAbstractExceptionEvent(int errorCode, String message) {
        this(errorCode, message, Severity.GENERIC);
    }

    protected IAbstractExceptionEvent(int errorCode, Throwable cause) {
        this(errorCode, cause.getMessage(), cause, Severity.GENERIC);
    }

    protected IAbstractExceptionEvent(int errorCode, String message, Throwable cause) {
        this(message, cause);
        this.init(errorCode, Severity.GENERIC);
    }

    protected IAbstractExceptionEvent(int errorCode, String message, Severity severity) {
        this(message);
        this.init(errorCode, severity);
    }

    protected IAbstractExceptionEvent(int errorCode, Throwable cause, Severity severity) {
        this(cause);
        this.init(errorCode, severity);
    }

    protected IAbstractExceptionEvent(int errorCode, String message, Throwable cause, Severity severity) {
        this(message, cause);
        this.init(errorCode, severity);
    }

    private void init(int errorCode, Severity severity) {
        this.errorCode = errorCode;
        this.severity = severity;
    }

    protected abstract void init();

    @Override
    public String getEventKey() {
        return this.eventKey;
    }

    @Override
    public void setEventKey(String eventKey) {
        this.assertState();
        this.eventKey = eventKey;
    }

    @Override
    public String getEventGroupId() {
        return this.eventGroupId;
    }

    @Override
    public void setEventGroupId(String eventGroupId) {
        this.assertState();
        this.eventGroupId = eventGroupId;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId != null ? new String(this.correlationId) : null;
    }

    @Override
    public void setCorrelationId(String correlationId) {
        this.assertState();
        this.correlationId = correlationId != null ? correlationId.getBytes() : null;
    }

    @Override
    public byte[] getCorrelationIdAsBytes() {
        return this.correlationId != null ? (byte[])this.correlationId.clone() : null;
    }

    @Override
    public void setCorrelationIdAsBytes(byte[] correlationId) {
        this.assertState();
        this.correlationId = correlationId;
    }

    @Override
    public void setErrorCode(int errorCode) {
        this.assertState();
        this.errorCode = errorCode;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorCodeAsString() {
        return this.errPrefix + (this.errorCode < 0 ? "" : "-") + this.errorCode;
    }

    public String getErrorPrefix() {
        return this.errPrefix;
    }

    @Override
    public void setSeverity(Severity severity) {
        this.assertState();
        this.severity = severity;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public byte[] getEventSource() {
        return this.eventSource != null ? (byte[])this.eventSource.clone() : null;
    }

    @Override
    public byte[] getEventSink() {
        return this.eventSink != null ? (byte[])this.eventSink.clone() : null;
    }

    @Override
    public void setEventSink(byte[] eventSink) {
        this.assertState();
        this.eventSink = eventSink;
    }

    @Override
    public Date getTimestamp() {
        return new Date(this.timeStamp);
    }

    @Override
    public String getErrorMessage() {
        return this.getMessage();
    }

    @Override
    public long getSerialVersionUID() {
        return this.serialVersionUID;
    }

    protected void setSerialVersionUID(long serialVersionUID) {
        this.serialVersionUID = serialVersionUID;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    protected void setEventId(String eventId) throws SDOFormatException {
        this.assertState();
        SDOUtils.validateEventId(eventId);
        this.eventId = eventId;
    }

    void resetEventId() {
        this.eventId = null;
    }

    protected void assertState() throws SDORuntimeException {
        if (this.isCoalesced()) {
            throw new SDORuntimeException(ErrorMessages.format("Event [%1$s] is coalesced and cannot be modified.", this.eventId));
        }
    }

    protected void coalesce(FabricComponent source) throws SDORuntimeException {
        this.coalesce(source.getFabricAddress());
    }

    protected void coalesce(FabricAddress sourceAddress) throws SDORuntimeException {
        this.assertState();
        if (!this.isCoalescedAndReset()) {
            this.timeStamp = System.currentTimeMillis();
            this.eventSource = sourceAddress.toBinary();
        }
        this.coalesced = true;
    }

    public boolean isCoalesced() {
        return this.coalesced;
    }

    protected boolean isCoalescedAndReset() {
        return this.timeStamp != 0L && this.eventSource != null;
    }

    protected void reset(boolean full) {
        this.coalesced = false;
        if (full) {
            this.timeStamp = 0L;
            this.eventSource = null;
        }
    }

    @Override
    public byte getTransmitAccess() {
        return 46;
    }

    public void setDurable(boolean isDurable) {
        this.assertState();
        this.durable = isDurable;
    }

    @Override
    public boolean getDurable() {
        return this.durable;
    }

    @Override
    public void setReplyTo(String eventId) throws SDOFormatException {
        this.assertState();
        SDOUtils.validateEventId(eventId);
        this.eventReplyTo = eventId;
    }

    @Override
    public void resetReplyTo() {
        this.assertState();
        this.eventReplyTo = null;
    }

    @Override
    public String getReplyTo() {
        return this.eventReplyTo;
    }

    @Override
    public void setEventObjectProperty(String propertyName, Object property) throws SDOException {
        if (property instanceof String) {
            this.setEventStringProperty(propertyName, (String)property);
        } else if (property instanceof Boolean || property instanceof Byte || property instanceof Short || property instanceof Integer || property instanceof Long || property instanceof Float || property instanceof Double || property instanceof BigDecimal) {
            this.setProperty(propertyName, property);
        } else {
            if (property == null) {
                throw new SDOFormatException("Null value of property '" + propertyName + "'" + this.inEventInfo());
            }
            throw new SDOFormatException("Invalid type of property '" + propertyName + "'" + this.inEventInfo());
        }
    }

    @Override
    public Object getEventObjectProperty(String propertyName) throws SDOException {
        this.checkPropertyName(propertyName);
        return this.eventProperties != null ? this.eventProperties.get(propertyName) : null;
    }

    @Override
    public PropertyType getEventPropertyType(String propertyName) throws SDOException {
        Object propertyValue;
        this.checkPropertyName(propertyName);
        if (this.eventProperties != null && (propertyValue = this.getEventObjectProperty(propertyName)) != null) {
            return PropertyType.resolveType(propertyValue);
        }
        return null;
    }

    @Override
    public boolean canConvertEventProperty(String propertyName, PropertyType propertyType) throws SDOException {
        this.checkPropertyName(propertyName);
        if (this.eventProperties != null) {
            try {
                EventPropertyValidator.checkValue(propertyType, this.getEventObjectProperty(propertyName));
                return true;
            }
            catch (SDOPropertyException exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    public synchronized void removeEventProperty(String propertyName) throws SDOException {
        this.preparePropertyToChange(propertyName, "removed");
        if (this.eventProperties != null && this.eventProperties.containsKey(propertyName)) {
            if (this.isNormalEvent()) {
                throw new SDOPropertyException("Property '" + propertyName + "' cannot be removed" + this.fromEventInfo());
            }
            this.eventProperties.remove(propertyName);
        }
    }

    @Override
    public boolean existsEventProperty(String propertyName) throws SDOException {
        this.checkPropertyName(propertyName);
        return this.eventProperties != null && this.eventProperties.containsKey(propertyName);
    }

    @Override
    public Set<String> getEventPropertyNames() {
        return this.eventProperties != null ? new HashSet<String>(this.eventProperties.keySet()) : new HashSet();
    }

    @Override
    public void clearEventProperties() {
        this.assertState();
        this.eventProperties = null;
    }

    @Override
    public boolean getEventBooleanProperty(String name) throws SDOException {
        return this.getProperty(name, Boolean.class);
    }

    @Override
    public byte getEventByteProperty(String name) throws SDOException {
        return this.getProperty(name, Byte.class);
    }

    @Override
    public short getEventShortProperty(String name) throws SDOException {
        return this.getProperty(name, Short.class);
    }

    @Override
    public int getEventIntProperty(String name) throws SDOException {
        return this.getProperty(name, Integer.class);
    }

    @Override
    public long getEventLongProperty(String name) throws SDOException {
        return this.getProperty(name, Long.class);
    }

    @Override
    public float getEventFloatProperty(String name) throws SDOException {
        return this.getProperty(name, Float.class).floatValue();
    }

    @Override
    public double getEventDoubleProperty(String name) throws SDOException {
        return this.getProperty(name, Double.class);
    }

    @Override
    public BigDecimal getEventBigDecimalProperty(String name) throws SDOException {
        return this.getProperty(name, BigDecimal.class);
    }

    @Override
    public String getEventStringProperty(String name) throws SDOException {
        return this.getProperty(name, String.class);
    }

    @Override
    public void setEventBooleanProperty(String name, boolean value) throws SDOException {
        this.setProperty(name, value);
    }

    @Override
    public void setEventByteProperty(String name, byte value) throws SDOException {
        this.setProperty(name, value);
    }

    @Override
    public void setEventShortProperty(String name, short value) throws SDOException {
        this.setProperty(name, value);
    }

    @Override
    public void setEventIntProperty(String name, int value) throws SDOException {
        this.setProperty(name, value);
    }

    @Override
    public void setEventLongProperty(String name, long value) throws SDOException {
        this.setProperty(name, value);
    }

    @Override
    public void setEventFloatProperty(String name, float value) throws SDOException {
        this.setProperty(name, Float.valueOf(value));
    }

    @Override
    public void setEventDoubleProperty(String name, double value) throws SDOException {
        this.setProperty(name, value);
    }

    @Override
    public void setEventBigDecimalProperty(String name, BigDecimal value) throws SDOException {
        this.setProperty(name, value);
    }

    @Override
    public void setEventBigDecimalProperty(String name, int precision, int scale) throws SDOException {
        this.preparePropertyToChange(name, "set");
        if (this.isNormalEvent()) {
            throw new SDOPropertyException("Event is not an event prototype.");
        }
        if (precision < 0) {
            throw new SDOPropertyException("Precision must be a positive number.");
        }
        if (scale < 0) {
            throw new SDOPropertyException("Scale must not be a negative number.");
        }
        this.doSetProperty(name, EventPropertyValidator.makeBigDecimalTemplate(precision, scale));
    }

    @Override
    public synchronized void setEventStringProperty(String name, String value) throws SDOException {
        if (value == null) {
            throw new SDOFormatException("Null value of property '" + name + "'" + this.inEventInfo());
        }
        if (StringUtils.lengthUTF(value) - 2 > 65535) {
            throw new SDOFormatException("String property '" + name + "' too large" + this.inEventInfo());
        }
        Object preparedValue = this.preparePropertyToSet(name, value);
        this.doSetProperty(name, preparedValue);
    }

    protected PropertyType getPropertyType(String sdrPath) throws SDOPropertyException {
        try {
            return this.doGetPropertyType(sdrPath);
        }
        catch (SDOPropertyException exception) {
            throw new SDOPropertyException(exception.getMessage(), exception.getCause());
        }
    }

    protected PropertyType doGetPropertyType(String sdrPath) throws SDOPropertyException {
        try {
            Class propertyClass = this.getPropertyClass(sdrPath);
            if (propertyClass.equals(Object.class)) {
                return null;
            }
            if (Enum.class.isAssignableFrom(propertyClass)) {
                return PropertyType.String;
            }
            return EventPropertyValidator.getPropertyType(propertyClass);
        }
        catch (Exception exception) {
            if (exception instanceof SDOPropertyException) {
                throw (SDOPropertyException)exception;
            }
            throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath), exception);
        }
    }

    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException, TypeAnalyzerException {
        return TypeAnalyzerFactory.getInstance().createTypeAnalyzer().getFieldClass(this.getClass(), sdrPath);
    }

    protected String getInvalidSDRPathMessage(String sdrPath) throws SDOPropertyException {
        return "Invalid SDR path '" + sdrPath + "'.";
    }

    protected <T> T getProperty(String name, Class<T> type) throws SDOException {
        try {
            return EventPropertyValidator.checkValue(type, this.getEventObjectProperty(name));
        }
        catch (SDOPropertyException exception) {
            throw new SDOPropertyException("Invalid data type of property '" + name + "'" + this.inEventInfo(), exception);
        }
    }

    protected synchronized void setProperty(String name, Object value) throws SDOException {
        value = this.preparePropertyToSet(name, value);
        this.doSetProperty(name, value);
    }

    protected void preparePropertyToChange(String name, String operation) throws SDOException {
        this.assertState();
        this.checkPropertyName(name);
    }

    protected Object preparePropertyToSet(String name, Object value) throws SDOException {
        this.preparePropertyToChange(name, "set");
        if (this.eventProperties != null && this.eventProperties.containsKey(name)) {
            Object oldValue = this.eventProperties.get(name);
            if (oldValue != null && !oldValue.getClass().equals(value.getClass())) {
                try {
                    return EventPropertyValidator.checkValue(PropertyType.resolveType(oldValue), value);
                }
                catch (SDOPropertyException exception) {
                    throw new SDOPropertyException("Invalid data type for property '" + name + "'" + this.inEventInfo());
                }
            }
        } else if (this.isNormalEvent()) {
            throw new SDOPropertyException("Property '" + name + "' does not exist" + this.inEventInfo());
        }
        return value;
    }

    protected void checkPropertyName(String name) throws SDOException {
        if (name == null || name.length() == 0) {
            throw new SDOFormatException("Invalid property name '" + name + "'" + this.inEventInfo());
        }
    }

    protected synchronized void doSetProperty(String name, Object value) throws SDOException {
        this.checkEventPropertiesExistence();
        this.eventProperties.put(name, this.updatePropertyValue(name, value));
    }

    Object updatePropertyValue(String name, Object value) {
        Object oldValue;
        if (value instanceof BigDecimal && this.isNormalEvent() && (oldValue = this.eventProperties.get(name)) instanceof BigDecimal) {
            BigDecimal mask = (BigDecimal)oldValue;
            return new BigDecimal(((BigDecimal)value).toPlainString(), new MathContext(EventPropertyValidator.getBigDecimalPrecision(mask))).setScale(mask.scale(), RoundingMode.HALF_UP);
        }
        return value;
    }

    protected boolean isNormalEvent() {
        return this.eventId != null && !this.eventId.startsWith("e.reply.") && !this.eventId.startsWith("e.sys.reply.");
    }

    protected void checkEventPropertiesExistence() throws SDOException {
        if (this.eventProperties == null) {
            this.eventProperties = new HashMap();
        }
    }

    protected String inEventInfo() {
        return this.inEventInfo(true);
    }

    protected String inEventInfo(boolean withDot) {
        return this.eventId != null ? " in event [" + this.eventId + "]." : (withDot ? "." : "");
    }

    protected String fromEventInfo() {
        return this.eventId != null ? " from event [" + this.eventId + "]." : ".";
    }

    @Override
    public IAbstractExceptionEvent clone() {
        try {
            IAbstractExceptionEvent result = (IAbstractExceptionEvent)super.clone();
            result.eventProperties = this.eventProperties != null ? (HashMap)this.eventProperties.clone() : null;
            return result;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String toString() {
        return this.getPrefix() + ": " + this.getMessage() + (String)(this.getCause() != null && this.getCause().getMessage() != null ? " Cause: " + this.getCause().getMessage() : "");
    }

    protected abstract String getPrefix();

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof IAbstractExceptionEvent) {
            IAbstractExceptionEvent otherEvent = (IAbstractExceptionEvent)other;
            return Utils.equalsNullSafe(this.getMessage(), otherEvent.getMessage()) && this.serialVersionUID == otherEvent.serialVersionUID && Arrays.equals(this.eventSource, otherEvent.eventSource) && Utils.equalsNullSafe(this.eventId, otherEvent.eventId) && Utils.equalsNullSafe(this.eventKey, otherEvent.eventKey) && Utils.equalsNullSafe(this.eventGroupId, otherEvent.eventGroupId) && Arrays.equals(this.correlationId, otherEvent.correlationId) && Utils.equalsNullSafe(this.eventReplyTo, otherEvent.eventReplyTo) && Arrays.equals(this.eventSink, otherEvent.eventSink) && Utils.equalsNullSafe(this.errPrefix, otherEvent.errPrefix) && this.errorCode == otherEvent.errorCode && Utils.equalsNullSafe((Object)this.severity, (Object)otherEvent.severity) && this.durable == otherEvent.durable && this.timeStamp == otherEvent.timeStamp && this.coalesced == otherEvent.coalesced && this.equalsEventProperties(otherEvent.eventProperties);
        }
        return false;
    }

    protected boolean equalsEventProperties(HashMap<String, Object> otherEventProperties) {
        if (this.eventProperties == otherEventProperties) {
            return true;
        }
        if (this.eventProperties != null && otherEventProperties != null && this.eventProperties.size() == otherEventProperties.size()) {
            for (Map.Entry<String, Object> entry : this.eventProperties.entrySet()) {
                if (Utils.equalsNullSafe(entry.getValue(), otherEventProperties.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

