/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.ReferenceCounter;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.utils.Utils;
import java.util.Arrays;
import java.util.Date;

public abstract class IAbstractEvent
extends CloneableDataObject
implements ImmutableEventDatagram {
    protected byte[] eventSource = null;
    protected String eventId = null;
    protected String eventKey = null;
    protected String eventGroupId = null;
    protected boolean durable = false;
    protected long timeStamp = 0L;
    protected boolean coalesced = false;
    protected transient ReferenceCounter dataCounter = null;

    protected IAbstractEvent() {
    }

    protected IAbstractEvent(String eventId) throws SDOFormatException {
        this.setEventId(eventId);
    }

    public void setEventId(String eventId) throws SDOFormatException {
        this.assertState();
        SDOUtils.validateEventId(eventId);
        this.eventId = eventId;
    }

    void resetEventId() {
        this.eventId = null;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    @Override
    public long getSerialVersionUID() {
        return 9969000000302071L;
    }

    public void setEventKey(String key) {
        this.assertState();
        this.eventKey = key;
    }

    @Override
    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventGroupId(String groupId) {
        this.assertState();
        this.eventGroupId = groupId;
    }

    @Override
    public String getEventGroupId() {
        return this.eventGroupId;
    }

    @Override
    public Date getTimestamp() {
        return new Date(this.timeStamp);
    }

    @Override
    public byte[] getEventSource() {
        return this.eventSource != null ? (byte[])this.eventSource.clone() : null;
    }

    public void setDurable(boolean isDurable) {
        this.assertState();
        this.durable = isDurable;
    }

    @Override
    public boolean getDurable() {
        return this.durable;
    }

    @Override
    public byte getTransmitAccess() {
        return 46;
    }

    protected void assertState() throws SDORuntimeException {
        if (this.isCoalesced()) {
            throw new SDORuntimeException(ErrorMessages.format("Event [%1$s] is coalesced and cannot be modified.", this.eventId));
        }
    }

    protected void coalesce(FabricComponent source) throws SDORuntimeException {
        this.coalesce(source.getFabricAddress());
    }

    protected void coalesce(FabricAddress sourceAddress) throws SDORuntimeException {
        this.assertState();
        if (!this.isCoalescedAndReset()) {
            this.timeStamp = System.currentTimeMillis();
            if (sourceAddress != null) {
                this.eventSource = sourceAddress.toBinary();
            }
        }
        this.coalesced = true;
    }

    public boolean isCoalesced() {
        return this.coalesced;
    }

    protected boolean isCoalescedAndReset() {
        return this.timeStamp != 0L && this.eventSource != null;
    }

    protected void reset(boolean full) {
        this.coalesced = false;
        if (full) {
            this.timeStamp = 0L;
            this.eventSource = null;
        }
    }

    protected Object getDataForAcknowledgement() throws SecurityViolationException, SDOException {
        return null;
    }

    @Override
    public synchronized IAbstractEvent clone() {
        IAbstractEvent result = (IAbstractEvent)super.clone();
        if (this.dataCounter == null) {
            result.dataCounter = this.dataCounter = new ReferenceCounter();
        }
        this.dataCounter.increment();
        return result;
    }

    protected synchronized void cloneData() throws SDOException {
        if (this.dataCounter != null && this.dataCounter.getCounter() > 1L) {
            this.doCloneData();
            this.dataCounter.decrement();
            this.dataCounter = null;
        }
    }

    protected void cloneDataSafe() {
        try {
            this.cloneData();
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void doCloneData() throws SDOException {
    }

    protected synchronized void resetDataCounter() {
        if (this.dataCounter != null && this.dataCounter.getCounter() > 1L) {
            this.dataCounter.decrement();
            this.dataCounter = null;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof IAbstractEvent) {
            IAbstractEvent otherEvent = (IAbstractEvent)other;
            return Arrays.equals(this.eventSource, otherEvent.eventSource) && Utils.equalsNullSafe(this.eventId, otherEvent.eventId) && Utils.equalsNullSafe(this.eventGroupId, otherEvent.eventGroupId) && Utils.equalsNullSafe(this.eventKey, otherEvent.eventKey) && this.durable == otherEvent.durable && this.timeStamp == otherEvent.timeStamp && this.coalesced == otherEvent.coalesced;
        }
        return false;
    }
}

